/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.repositories;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.Filters;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataDocument;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Graph;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.MMNode;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.TreeNode;
import gr.uoa.di.aginfra.data.analytics.visualization.model.persistence.MongoDataSourceManager;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.ConfigurationRepository;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.DataDocumentRepository;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class DataDocumentRepositoryImpl
implements DataDocumentRepository {
    private static final ObjectMapper mapper = new ObjectMapper();
    private MongoDataSourceManager mongoDataSourceManager;
    private ConfigurationRepository configurationDAO;

    @Autowired
    public DataDocumentRepositoryImpl(MongoDataSourceManager mongoDataSourceManager, @Lazy ConfigurationRepository configurationDAO) {
        this.mongoDataSourceManager = mongoDataSourceManager;
        this.configurationDAO = configurationDAO;
    }

    @Override
    public DataDocument getById(String id) throws Exception {
        GridFSBucket database = this.mongoDataSourceManager.getGridFS();
        GridFSFile file = (GridFSFile)database.find(Filters.eq((Object)new ObjectId(id))).first();
        if (file == null) {
            return null;
        }
        DataDocument dataDocument = new DataDocument();
        DataDocumentRepositoryImpl.mapMetadata(dataDocument, file.getMetadata());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        database.downloadToStream(file.getObjectId(), (OutputStream)outputStream);
        switch (dataDocument.getType()) {
            case Graph: {
                String data = new String(outputStream.toByteArray(), Charsets.UTF_8);
                dataDocument.setGraph((Graph)mapper.readValue(data, Graph.class));
                break;
            }
            case Tree: {
                String data = new String(outputStream.toByteArray(), Charsets.UTF_8);
                dataDocument.setTree((TreeNode)mapper.readValue(data, TreeNode.class));
                break;
            }
            case Records: {
                String data = new String(outputStream.toByteArray(), Charsets.UTF_8);
                dataDocument.setRecords((List)mapper.readValue(data, (TypeReference)new TypeReference<List<Map<String, String>>>(){}));
                break;
            }
            case FreeMind: {
                String data = new String(outputStream.toByteArray(), Charsets.UTF_8);
                dataDocument.setFreeMind((MMNode)mapper.readValue(data, MMNode.class));
                break;
            }
            case JSON: {
                String data = new String(outputStream.toByteArray(), Charsets.UTF_8);
                dataDocument.setJSON(data);
                break;
            }
            case Image: {
                dataDocument.setRawBytes(outputStream.toByteArray());
                break;
            }
            default: {
                throw new Exception("Invalid data type provided " + (Object)((Object)dataDocument.getType()));
            }
        }
        return dataDocument;
    }

    @Override
    public String store(DataDocument item) throws Exception {
        byte[] data;
        GridFSBucket database = this.mongoDataSourceManager.getGridFS();
        GridFSUploadOptions options = new GridFSUploadOptions().metadata(DataDocumentRepositoryImpl.mapMetadata(item));
        switch (item.getType()) {
            case Graph: {
                data = mapper.writeValueAsBytes((Object)item.getGraph());
                break;
            }
            case Tree: {
                data = mapper.writeValueAsBytes((Object)item.getTree());
                break;
            }
            case FreeMind: {
                data = mapper.writeValueAsBytes((Object)item.getFreeMind());
                break;
            }
            case Records: {
                data = mapper.writeValueAsBytes(item.getRecords());
                break;
            }
            case JSON: {
                data = item.getJSON().getBytes(StandardCharsets.UTF_8.name());
                break;
            }
            default: {
                data = item.getRawBytes();
            }
        }
        ObjectId id = database.uploadFromStream(item.getName(), (InputStream)new ByteArrayInputStream(data), options);
        return id.toString();
    }

    @Override
    public void delete(String id) throws Exception {
        GridFSBucket database = this.mongoDataSourceManager.getGridFS();
        database.delete(new ObjectId(id));
    }

    private static Document mapMetadata(DataDocument dataDocument) {
        Document document = new Document();
        if (dataDocument.getName() != null) {
            document.append("name", (Object)dataDocument.getName());
        }
        if (dataDocument.getVre() != null) {
            document.append("vre", (Object)dataDocument.getVre());
        }
        if (dataDocument.getFields() != null) {
            document.append("fields", dataDocument.getFields());
        }
        if (dataDocument.getType() != null) {
            document.append("type", (Object)dataDocument.getType().toString());
        }
        document.append("isDataReference", (Object)dataDocument.isDataReference());
        if (dataDocument.getCreatedAt() != null) {
            document.append("createdAt", (Object)dataDocument.getCreatedAt().getTime());
        }
        if (dataDocument.getUpdatedAt() != null) {
            document.append("updatedAt", (Object)dataDocument.getUpdatedAt().getTime());
        }
        return document;
    }

    private static void mapMetadata(DataDocument dataDocument, Document document) {
        if (document.containsKey((Object)"name") && document.getString((Object)"name") != null) {
            dataDocument.setName(document.getString((Object)"name"));
        }
        if (document.containsKey((Object)"vre") && document.getString((Object)"vre") != null) {
            dataDocument.setVre(document.getString((Object)"vre"));
        }
        if (document.containsKey((Object)"fields")) {
            dataDocument.setFields((List)mapper.convertValue(document.get((Object)"fields"), (TypeReference)new TypeReference<List<String>>(){}));
        }
        if (document.containsKey((Object)"type") && document.getString((Object)"type") != null) {
            dataDocument.setType(DataType.valueOf(document.getString((Object)"type")));
        }
        if (document.containsKey((Object)"isDataReference")) {
            dataDocument.setDataReference(document.getBoolean((Object)"isDataReference"));
        }
        if (document.containsKey((Object)"fields")) {
            dataDocument.setFields((List)mapper.convertValue(document.get((Object)"fields"), (TypeReference)new TypeReference<List<String>>(){}));
        }
        if (document.containsKey((Object)"createdAt") && document.getLong((Object)"createdAt") != null) {
            dataDocument.setCreatedAt(new Date(document.getLong((Object)"createdAt")));
        }
        if (document.containsKey((Object)"updatedAt") && document.getLong((Object)"updatedAt") != null) {
            dataDocument.setUpdatedAt(new Date(document.getLong((Object)"updatedAt")));
        }
    }
}

