/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.services;

import gr.uoa.di.aginfra.data.analytics.visualization.model.data.DataSetExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.DataSetExtractorFactory;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Configuration;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataSource;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.VisualizationMapper;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.ConfigurationRepository;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.VisualizationDataType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.VisualizationService;
import gr.uoa.di.aginfra.data.analytics.visualization.model.stats.UsageStatsService;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.Visualization;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.VisualizationDataGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.VisualizationDataGeneratorFactory;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.operations.JoinExecutor;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualizationServiceImpl
implements VisualizationService {
    private ConfigurationRepository configurationDAO;
    private VisualizationMapper visualizationMapper;
    private DataSetExtractorFactory dataSetExtractorFactory;
    private JoinExecutor joinExecutor;
    private VisualizationDataGeneratorFactory visualizationDataGeneratorFactory;
    private UsageStatsService usageService;

    @Autowired
    public VisualizationServiceImpl(ConfigurationRepository configurationDAO, VisualizationMapper visualizationMapper, DataSetExtractorFactory dataSetExtractorFactory, JoinExecutor joinExecutor, VisualizationDataGeneratorFactory visualizationDataGeneratorFactory, UsageStatsService usageService) {
        this.configurationDAO = configurationDAO;
        this.visualizationMapper = visualizationMapper;
        this.dataSetExtractorFactory = dataSetExtractorFactory;
        this.joinExecutor = joinExecutor;
        this.visualizationDataGeneratorFactory = visualizationDataGeneratorFactory;
        this.usageService = usageService;
    }

    @Override
    public Visualization getVisualization(String id) throws Exception {
        return this.getVisualization(id, null);
    }

    @Override
    public Visualization getVisualization(String id, Map<String, String> filters) throws Exception {
        Configuration configuration = this.configurationDAO.getById(id);
        if (configuration == null) {
            return null;
        }
        Visualization visualization = this.visualizationMapper.map(configuration);
        visualization.setHasColors(configuration.getColorField() != null && configuration.getColorField().length() > 0);
        visualization.setHasDocuments(configuration.getDocumentField() != null && configuration.getDocumentField().length() > 0);
        this.loadDataSet(configuration, visualization, filters);
        this.usageService.visualizationVisited("dev", "devel", id);
        return visualization;
    }

    private void loadDataSet(Configuration configuration, Visualization visualization, Map<String, String> filters) throws Exception {
        VisualizationDataType dataType = VisualizationDataType.of(visualization.getType());
        DataSet dataSet = this.extract(configuration, dataType);
        VisualizationDataGenerator generator = this.visualizationDataGeneratorFactory.getGenerator(dataType);
        generator.generateData(visualization, configuration, dataSet, filters);
    }

    private DataSet extract(Configuration configuration, VisualizationDataType dataType) throws Exception {
        if (configuration.getDataSources().size() == 1) {
            DataSource dataSource = configuration.getDataSources().get(0);
            DataSetExtractor dataSetExtractor = this.dataSetExtractorFactory.getExtractor(dataSource);
            return dataSetExtractor.extract(dataSource, dataType);
        }
        return this.joinExecutor.execute(configuration.getDataSources(), configuration.getJoins(), dataType);
    }
}

