/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.filters;

import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSetManipulator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.filters.FilterOptionsExtractor;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class FilterOptionsExtractorImpl
extends DataSetManipulator
implements FilterOptionsExtractor {
    @Override
    public List<String> extract(DataSet dataSet, String filterField) throws Exception {
        int filterFieldIndex = -1;
        if (filterField == null || (filterFieldIndex = this.getFieldIndex(dataSet, filterField)) == -1) {
            throw new Exception("Invalid data field provided " + filterField);
        }
        Set<Object> options = new HashSet();
        ColumnType columnType = this.getColumnType(dataSet, filterFieldIndex);
        options = this.getDistinctGroupByValues(dataSet, columnType, filterFieldIndex);
        return options.stream().filter(s -> s != null && !s.isEmpty()).sorted().collect(Collectors.toList());
    }

    private ColumnType getColumnType(DataSet dataSet, int groupByFieldIndex) throws ParseException {
        String s;
        Date result;
        if (groupByFieldIndex != -1 && (result = this.parseDate(s = dataSet.getData().get(0).get(groupByFieldIndex))) != null) {
            return ColumnType.Date;
        }
        return ColumnType.String;
    }

    private Set<String> getDistinctGroupByValues(DataSet dataSet, ColumnType columnType, int groupByFieldIndex) throws ParseException {
        HashSet<String> distinctGroupByValues = new HashSet<String>();
        switch (columnType) {
            case Date: {
                for (int i = 0; i < dataSet.getData().size(); ++i) {
                    String dateWithoutTime = this.getDateWithoutTime(this.parseDate(dataSet.getData().get(i).get(groupByFieldIndex))).toString();
                    distinctGroupByValues.add(dateWithoutTime);
                    dataSet.getData().get(i).set(groupByFieldIndex, dateWithoutTime);
                }
                break;
            }
            default: {
                for (List<String> row : dataSet.getData()) {
                    distinctGroupByValues.add(row.get(groupByFieldIndex));
                }
            }
        }
        return distinctGroupByValues;
    }

    static enum ColumnType {
        Date,
        String;

    }
}

