/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.definitions;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.VisualizationType;
import java.util.HashMap;
import java.util.Map;

public enum DataType {
    Records,
    Tree,
    Graph,
    FreeMind,
    Image,
    JSON;

    private static Map<VisualizationType, DataType> visualizationTypeDataTypeMap;

    private static void initializeMap() {
        visualizationTypeDataTypeMap = new HashMap<VisualizationType, DataType>();
        visualizationTypeDataTypeMap.put(VisualizationType.Graph, Graph);
        visualizationTypeDataTypeMap.put(VisualizationType.Tree, Tree);
        visualizationTypeDataTypeMap.put(VisualizationType.MindMap, FreeMind);
        visualizationTypeDataTypeMap.put(VisualizationType.Line, Records);
        visualizationTypeDataTypeMap.put(VisualizationType.Scatter, Records);
        visualizationTypeDataTypeMap.put(VisualizationType.Spline, Records);
        visualizationTypeDataTypeMap.put(VisualizationType.Step, Records);
        visualizationTypeDataTypeMap.put(VisualizationType.Pie, Records);
        visualizationTypeDataTypeMap.put(VisualizationType.Doughnut, Records);
        visualizationTypeDataTypeMap.put(VisualizationType.Polar, Records);
        visualizationTypeDataTypeMap.put(VisualizationType.Bar, Records);
        visualizationTypeDataTypeMap.put(VisualizationType.ThreeD, Records);
        visualizationTypeDataTypeMap.put(VisualizationType.Map, JSON);
        visualizationTypeDataTypeMap.put(VisualizationType.WorldWindMap, JSON);
        visualizationTypeDataTypeMap.put(VisualizationType.Table, Records);
        visualizationTypeDataTypeMap.put(VisualizationType.HeatMap, Records);
    }

    public static DataType of(VisualizationType visualizationType) {
        if (visualizationTypeDataTypeMap == null) {
            DataType.initializeMap();
        }
        return visualizationTypeDataTypeMap.get((Object)visualizationType);
    }
}

