/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.services;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.VisualizationType;
import java.util.HashMap;
import java.util.Map;

public enum VisualizationDataType {
    BarChart,
    TimeSeries,
    Tuples,
    ThreeD,
    Tree,
    Graph,
    FreeMind,
    Map,
    Tabular,
    HeatMap;

    private static Map<VisualizationType, VisualizationDataType> visualizationTypeDataTypeMap;

    private static void initializeMap() {
        visualizationTypeDataTypeMap = new HashMap<VisualizationType, VisualizationDataType>();
        visualizationTypeDataTypeMap.put(VisualizationType.Line, TimeSeries);
        visualizationTypeDataTypeMap.put(VisualizationType.Scatter, TimeSeries);
        visualizationTypeDataTypeMap.put(VisualizationType.Spline, TimeSeries);
        visualizationTypeDataTypeMap.put(VisualizationType.Step, TimeSeries);
        visualizationTypeDataTypeMap.put(VisualizationType.Pie, Tuples);
        visualizationTypeDataTypeMap.put(VisualizationType.HeatMap, HeatMap);
        visualizationTypeDataTypeMap.put(VisualizationType.Doughnut, Tuples);
        visualizationTypeDataTypeMap.put(VisualizationType.Polar, Tuples);
        visualizationTypeDataTypeMap.put(VisualizationType.Bar, BarChart);
        visualizationTypeDataTypeMap.put(VisualizationType.ThreeD, ThreeD);
        visualizationTypeDataTypeMap.put(VisualizationType.Graph, Graph);
        visualizationTypeDataTypeMap.put(VisualizationType.Tree, Tree);
        visualizationTypeDataTypeMap.put(VisualizationType.MindMap, FreeMind);
        visualizationTypeDataTypeMap.put(VisualizationType.Map, Map);
        visualizationTypeDataTypeMap.put(VisualizationType.WorldWindMap, Map);
        visualizationTypeDataTypeMap.put(VisualizationType.Table, Tabular);
    }

    public static VisualizationDataType of(VisualizationType visualizationType) {
        if (visualizationTypeDataTypeMap == null) {
            VisualizationDataType.initializeMap();
        }
        return visualizationTypeDataTypeMap.get((Object)visualizationType);
    }
}

