/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Configuration;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.BarChartData;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSetManipulator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors.BarChartDataExtractor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class BarChartDataExtractorImpl
extends DataSetManipulator
implements BarChartDataExtractor {
    @Override
    public BarChartData extract(DataSet dataSet, Configuration configuration) throws Exception {
        String groupBy = configuration.getGroupBy();
        String xAxisField = configuration.getXAxis();
        String yAxisField = configuration.getYAxis();
        String colorField = configuration.getColorField();
        int groupByIndex = -1;
        if (groupBy != null && !groupBy.isEmpty()) {
            groupByIndex = this.getFieldIndex(dataSet, groupBy);
        }
        int xAxisFieldIndex = -1;
        if (xAxisField == null || (xAxisFieldIndex = this.getFieldIndex(dataSet, xAxisField)) == -1) {
            throw new Exception("Invalid data field provided " + xAxisField);
        }
        int yAxisFieldIndex = -1;
        if (yAxisField == null || (yAxisFieldIndex = this.getFieldIndex(dataSet, yAxisField)) == -1) {
            throw new Exception("Invalid data field provided " + yAxisField);
        }
        int colorIndex = -1;
        if (colorField != null) {
            colorIndex = this.getFieldIndex(dataSet, colorField);
        }
        return this.extractBarChartData(dataSet, groupByIndex, xAxisFieldIndex, yAxisFieldIndex, colorIndex);
    }

    private BarChartData extractBarChartData(DataSet dataSet, int groupByIndex, int xAxisFieldIndex, int yAxisFieldIndex, int colorIndex) {
        BarChartData barChartData = new BarChartData();
        XAxisGroupsAndMap xAxisGroupsAndMap = this.extactXAxisGroups(dataSet, xAxisFieldIndex);
        barChartData.setxAxisGroups(xAxisGroupsAndMap.xAxisGroups);
        Collection<BarChartData.DataSet> dataSets = groupByIndex < 0 ? this.extractNoGrouping(dataSet, xAxisGroupsAndMap, xAxisFieldIndex, yAxisFieldIndex, colorIndex) : this.extractByGrouping(dataSet, xAxisGroupsAndMap, groupByIndex, xAxisFieldIndex, yAxisFieldIndex, colorIndex);
        barChartData.setDataSets(dataSets);
        return barChartData;
    }

    private Collection<BarChartData.DataSet> extractNoGrouping(DataSet dataSet, XAxisGroupsAndMap xAxisGroupsAndMap, int xAxisFieldIndex, int yAxisFieldIndex, int colorIndex) {
        BarChartData.DataSet singleDataSet = this.createDataset("All", xAxisGroupsAndMap.xAxisGroupsMap.size());
        for (List<String> row : dataSet.getData()) {
            String xAxisGroup = row.get(xAxisFieldIndex);
            List<BigDecimal> yAxisData = singleDataSet.getData();
            try {
                yAxisData.set(xAxisGroupsAndMap.xAxisGroupsMap.get(xAxisGroup), new BigDecimal(row.get(yAxisFieldIndex)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (colorIndex <= -1 || singleDataSet.getColor() != null) continue;
            singleDataSet.setColor(row.get(colorIndex));
        }
        ArrayList<BarChartData.DataSet> list = new ArrayList<BarChartData.DataSet>();
        list.add(singleDataSet);
        return list;
    }

    private Collection<BarChartData.DataSet> extractByGrouping(DataSet dataSet, XAxisGroupsAndMap xAxisGroupsAndMap, int groupByIndex, int xAxisFieldIndex, int yAxisFieldIndex, int colorIndex) {
        HashMap<String, BarChartData.DataSet> dataSets = new HashMap<String, BarChartData.DataSet>();
        for (List<String> row : dataSet.getData()) {
            String group = row.get(groupByIndex);
            String xAxisGroup = row.get(xAxisFieldIndex);
            BarChartData.DataSet chartDataSet = this.getOrCreateDataset(dataSets, group, xAxisGroupsAndMap.xAxisGroupsMap.size());
            List<BigDecimal> yAxisData = chartDataSet.getData();
            try {
                yAxisData.set(xAxisGroupsAndMap.xAxisGroupsMap.get(xAxisGroup), new BigDecimal(row.get(yAxisFieldIndex)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (colorIndex <= -1 || chartDataSet.getColor() != null) continue;
            chartDataSet.setColor(row.get(colorIndex));
        }
        return dataSets.values();
    }

    private XAxisGroupsAndMap extactXAxisGroups(DataSet dataSet, int xAxisFieldIndex) {
        ArrayList<String> xAxisGroups = new ArrayList<String>();
        HashMap<String, Integer> xAxisGroupsMap = new HashMap<String, Integer>();
        int idx = 0;
        for (List<String> row : dataSet.getData()) {
            String xAxisGroup = row.get(xAxisFieldIndex);
            if (xAxisGroupsMap.containsKey(xAxisGroup)) continue;
            xAxisGroupsMap.put(xAxisGroup, idx++);
            xAxisGroups.add(xAxisGroup);
        }
        XAxisGroupsAndMap struct = new XAxisGroupsAndMap();
        struct.xAxisGroups = xAxisGroups;
        struct.xAxisGroupsMap = xAxisGroupsMap;
        return struct;
    }

    private BarChartData.DataSet getOrCreateDataset(Map<String, BarChartData.DataSet> available, String name, int groups) {
        if (available.containsKey(name)) {
            return available.get(name);
        }
        BarChartData.DataSet barChartData = this.createDataset(name, groups);
        available.put(name, barChartData);
        return barChartData;
    }

    private BarChartData.DataSet createDataset(String name, int groups) {
        BarChartData.DataSet barChartData = new BarChartData.DataSet(name);
        ArrayList<BigDecimal> data = new ArrayList<BigDecimal>();
        for (int i = 0; i < groups; ++i) {
            data.add(new BigDecimal(0));
        }
        barChartData.setData(data);
        return barChartData;
    }

    private class XAxisGroupsAndMap {
        List<String> xAxisGroups;
        HashMap<String, Integer> xAxisGroupsMap;

        private XAxisGroupsAndMap() {
        }
    }
}

