/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.DateNode;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.HasDateNode;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.NodeProperty;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.SubGraphEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;

@NodeEntity
public class Node
extends SubGraphEntity {
    @Id
    @GeneratedValue
    private Long id;
    private String nodeId;
    private double x;
    private double y;
    private int startingDate;
    @Relationship(type="HAS_PROPERTY")
    private List<NodeProperty> nodeProperties;
    @Relationship(type="HAS_DATENODE")
    private Set<HasDateNode> hasDateNodes = new HashSet<HasDateNode>();

    public Node() {
    }

    public Node(String nodeId, double x, double y, Map<String, String> attributes, String graphId, String graphName, String tenantName) {
        this.nodeId = nodeId;
        this.x = x;
        this.y = y;
        this.nodeProperties = new ArrayList<NodeProperty>();
        int i = 0;
        Iterator<Map.Entry<String, String>> it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (entry.getKey().matches("[a-zA-Z ]+")) {
                NodeProperty nodeProperty = new NodeProperty(entry.getKey(), entry.getValue(), this);
                this.nodeProperties.add(nodeProperty);
                it.remove();
            } else if (i == 0) {
                this.setStartingDate(Integer.parseInt(entry.getKey().replace(".", "")));
            }
            ++i;
        }
        this.setSubGraphId(graphId);
        this.setSubGraphName(graphName);
        this.setTenantName(tenantName);
        this.hasDateNodes = attributes.entrySet().stream().map(e -> new HasDateNode(this, new DateNode((String)e.getKey(), (String)e.getValue(), this))).collect(Collectors.toSet());
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public Set<HasDateNode> getHasDateNodes() {
        return this.hasDateNodes;
    }

    public void setHasDateNodes(Set<HasDateNode> hasDateNodes) {
        this.hasDateNodes = hasDateNodes;
    }

    public List<NodeProperty> getNodeProperties() {
        return this.nodeProperties;
    }

    public void setNodeProperties(List<NodeProperty> nodeProperties) {
        this.nodeProperties = nodeProperties;
    }

    public int getStartingDate() {
        return this.startingDate;
    }

    public void setStartingDate(int startingDate) {
        this.startingDate = startingDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

