/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.helpers;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.DateNode;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.HasDateNode;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.HasWeight;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.Node;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.NodeProperty;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.NetworkGraphService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.ogm.session.Utils;

public class D3Helper {
    public static Map<String, Object> nodesToD3Format(Collection<Node> nodeEntities, boolean isInitialization) {
        ArrayList<Map> nodes = new ArrayList<Map>();
        ArrayList<Map> rels = new ArrayList<Map>();
        int i = 0;
        for (Node node : nodeEntities) {
            Map nodeMap = Utils.map((Object[])new Object[]{"id", node.getNodeId(), "latitude", node.getX(), "longitude", node.getY()});
            for (NodeProperty property : node.getNodeProperties()) {
                nodeMap.put(property.getName(), property.getValue());
            }
            nodes.add(nodeMap);
            for (HasDateNode hasDateNode : node.getHasDateNodes()) {
                rels.add(Utils.map((Object[])new Object[]{"source", node.getNodeId(), "target", hasDateNode.getTarget().getHasWeight().getTarget().getParentId(), "weight", hasDateNode.getTarget().getHasWeight().getWeight(), "color", "lightblue", "highlightColor", "lightblue"}));
            }
        }
        if (isInitialization && rels.size() == 0) {
            Node source = null;
            for (Node node : nodeEntities) {
                if (i > 0) {
                    rels.add(Utils.map((Object[])new Object[]{"source", source.getNodeId(), "target", node.getNodeId(), "color", "transparent", "highlightColor", "lightblue"}));
                } else {
                    source = node;
                }
                ++i;
            }
        }
        return Utils.map((Object[])new Object[]{"nodes", nodes, "links", rels});
    }

    public static Map<String, Object> neighborsNodesToD3Format(Collection<Node> nodeEntities, String sourceId, boolean isInitialization) {
        ArrayList<Map> nodes = new ArrayList<Map>();
        ArrayList<Map> rels = new ArrayList<Map>();
        int i = 0;
        for (Node node : nodeEntities) {
            Map nodeMap = Utils.map((Object[])new Object[]{"id", node.getNodeId()});
            for (NodeProperty property : node.getNodeProperties()) {
                nodeMap.put(property.getName(), property.getValue());
            }
            nodes.add(nodeMap);
            rels.add(Utils.map((Object[])new Object[]{"source", sourceId, "target", node.getNodeId(), "color", "lightblue", "highlightColor", "blue"}));
        }
        if (isInitialization && rels.size() == 0) {
            Node source = null;
            for (Node node : nodeEntities) {
                if (i > 0) {
                    rels.add(Utils.map((Object[])new Object[]{"source", source.getNodeId(), "target", node.getNodeId(), "color", "transparent", "highlightColor", "transparent"}));
                } else {
                    source = node;
                }
                ++i;
            }
        }
        return Utils.map((Object[])new Object[]{"nodes", nodes, "links", rels});
    }

    public static Map<String, Object> dateNodesToD3Format(Collection<DateNode> dateNodesEntities) {
        ArrayList<Map> nodes = new ArrayList<Map>();
        ArrayList<Map> rels = new ArrayList<Map>();
        for (DateNode dateNode : dateNodesEntities) {
            Map nodeMap = Utils.map((Object[])new Object[]{"id", dateNode.getParentId()});
            for (NodeProperty property : dateNode.getParentNode().getNodeProperties()) {
                nodeMap.put(property.getName(), property.getValue());
            }
            nodes.add(nodeMap);
            rels.add(Utils.map((Object[])new Object[]{"source", dateNode.getParentNode().getNodeId(), "target", dateNode.getHasWeight().getTarget().getParentNode().getNodeId(), "weight", dateNode.getHasWeight().getWeight()}));
        }
        return Utils.map((Object[])new Object[]{"nodes", nodes, "links", rels});
    }

    public static Map<String, Object> hasWeightToD3Format(Collection<HasWeight> nodeEntities, String graphId, NetworkGraphService networkGraphService) {
        ArrayList<Map> nodes = new ArrayList<Map>();
        HashSet<Map> rels = new HashSet<Map>();
        boolean i = false;
        Iterator<HasWeight> result = nodeEntities.iterator();
        HashMap<String, Node> existedNodes = new HashMap<String, Node>();
        HashMap<String, String> existedLinks = new HashMap<String, String>();
        HashSet<String> targetIds = new HashSet<String>();
        while (result.hasNext()) {
            HasWeight hasWeight = result.next();
            Node node = hasWeight.getSource().getParentNode();
            if (node == null) {
                node = networkGraphService.findNodeById(hasWeight.getSource().getParentId(), graphId);
            }
            if (existedNodes.get(node.getNodeId()) == null) {
                existedNodes.put(hasWeight.getSource().getParentId(), node);
                Map nodeMap = Utils.map((Object[])new Object[]{"id", node.getNodeId(), "value", hasWeight.getSource().getProperty()});
                for (NodeProperty property : node.getNodeProperties()) {
                    nodeMap.put(property.getName(), property.getValue());
                }
                nodes.add(nodeMap);
            }
            if (existedLinks.get(node.getNodeId() + "," + hasWeight.getTarget().getParentId()) != null) continue;
            existedLinks.put(node.getNodeId() + "," + hasWeight.getTarget().getParentId(), "");
            targetIds.add(hasWeight.getTarget().getParentId());
            rels.add(Utils.map((Object[])new Object[]{"source", node.getNodeId(), "target", hasWeight.getTarget().getParentId(), "weight", hasWeight.getWeight(), "color", "lightblue", "highlightColor", "blue"}));
        }
        targetIds.stream().forEach(t -> {
            Node node;
            if (existedNodes.get(t) == null && (node = networkGraphService.findNodeById((String)t, graphId)) != null) {
                Map nodeMap = Utils.map((Object[])new Object[]{"id", node.getNodeId()});
                for (NodeProperty property : node.getNodeProperties()) {
                    nodeMap.put(property.getName(), property.getValue());
                }
                nodes.add(nodeMap);
            }
        });
        return Utils.map((Object[])new Object[]{"nodes", nodes, "links", rels});
    }

    public static List<String> datesToDateStrings(List<String> dates) {
        List<String> dateStrings = dates.stream().map(date -> {
            StringBuilder sb = new StringBuilder((String)date);
            sb.insert(4, '.');
            return sb.toString();
        }).collect(Collectors.toList());
        return dateStrings;
    }
}

