/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.service.controllers;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataDocument;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.ConfigurationService;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.DataDocumentMetadata;
import gr.uoa.di.aginfra.data.analytics.visualization.service.controllers.BaseController;
import gr.uoa.di.aginfra.data.analytics.visualization.service.vres.VREResolver;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@CrossOrigin(exposedHeaders={"Location"})
@RequestMapping(value={"/dataDocuments"})
public class DataDocumentController
extends BaseController {
    protected static final String DATA_DOCUMENT_BASE_PATH = "dataDocuments";
    private ConfigurationService configurationService;
    private VREResolver vreResolver;

    @Autowired
    public DataDocumentController(ConfigurationService configurationService, VREResolver vreResolver) {
        this.configurationService = configurationService;
        this.vreResolver = vreResolver;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<DataDocument> get(@PathVariable(value="id") String id) throws Exception {
        DataDocument entity = this.configurationService.getDataDocument(id);
        if (entity == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)entity);
    }

    @RequestMapping(value={"/{id}/metadata"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<DataDocumentMetadata> getMetadata(@PathVariable(value="id") String id) throws Exception {
        DataDocumentMetadata entity = this.configurationService.getDataDocumentMetadata(id);
        if (entity == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)entity);
    }

    @RequestMapping(value={"/{id}/data"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    public ResponseEntity<byte[]> getData(@PathVariable(value="id") String id) throws Exception {
        DataDocument entity = this.configurationService.getDataDocument(id);
        if (entity == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)entity.getRawBytes());
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public ResponseEntity<String> post(@RequestParam(value="file") MultipartFile[] file, String name, DataType type, Boolean isDataReference) throws Exception {
        String id = this.configurationService.storeDataDocument(this.vreResolver.resolve(), name, type, isDataReference != null ? isDataReference : false, file[0].getBytes());
        UriComponents uriComponents = UriComponentsBuilder.newInstance().path("dataDocuments/{id}").buildAndExpand(new Object[]{id});
        return ResponseEntity.created((URI)uriComponents.toUri()).body((Object)id);
    }
}

