/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.service.controllers;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Configuration;
import gr.uoa.di.aginfra.data.analytics.visualization.model.dtos.ConfigurationCriteriaDto;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.ConfigurationService;
import gr.uoa.di.aginfra.data.analytics.visualization.service.controllers.BaseController;
import gr.uoa.di.aginfra.data.analytics.visualization.service.dtos.ConfigurationDto;
import gr.uoa.di.aginfra.data.analytics.visualization.service.mappers.EntityMapper;
import gr.uoa.di.aginfra.data.analytics.visualization.service.vres.VREResolver;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@CrossOrigin(exposedHeaders={"Location"})
@RequestMapping(value={"/configurations"})
public class ConfigurationController
extends BaseController {
    private static final Logger logger = LogManager.getLogger(ConfigurationController.class);
    protected static final String CONFIGURATION_BASE_PATH = "configurations";
    private ConfigurationService configurationService;
    private EntityMapper modelMapper;
    private VREResolver vreResolver;

    @Autowired
    public ConfigurationController(ConfigurationService configurationService, EntityMapper modelMapper, VREResolver vreResolver) {
        this.configurationService = configurationService;
        this.modelMapper = modelMapper;
        this.vreResolver = vreResolver;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<List<ConfigurationDto>> list(ConfigurationCriteriaDto criteriaDto) throws Exception {
        List configurations = this.configurationService.getConfigurations(criteriaDto, this.vreResolver.resolve());
        List dtos = configurations.stream().map(entity -> this.modelMapper.map(entity)).collect(Collectors.toList());
        return ResponseEntity.ok(dtos);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<ConfigurationDto> get(@PathVariable(value="id") String id) throws Exception {
        logger.debug("Get configuration " + id);
        Configuration entity = this.configurationService.getConfiguration(id);
        if (entity == null) {
            return ResponseEntity.notFound().build();
        }
        ConfigurationDto dto = this.modelMapper.map(entity);
        return ResponseEntity.ok((Object)dto);
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResponseEntity<String> post(@Validated @RequestBody ConfigurationDto dto) throws Exception {
        Configuration entity = this.modelMapper.map(dto);
        entity.setVre(this.vreResolver.resolve());
        String id = this.configurationService.storeConfiguration(entity);
        UriComponents uriComponents = UriComponentsBuilder.newInstance().path("configurations/{id}").buildAndExpand(new Object[]{id});
        return ResponseEntity.created((URI)uriComponents.toUri()).body((Object)id);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"})
    public ResponseEntity<String> put(@PathVariable(value="id") String id, @RequestBody ConfigurationDto dto) throws Exception {
        Configuration entity = this.modelMapper.map(dto);
        entity.setId(id);
        entity.setVre(this.vreResolver.resolve());
        this.configurationService.storeConfiguration(entity);
        return ResponseEntity.ok((Object)"");
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="id") String id) throws Exception {
        this.configurationService.deleteConfiguration(id);
        return ResponseEntity.ok((Object)"");
    }
}

