/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.service.controllers;

import gr.uoa.di.aginfra.data.analytics.visualization.model.stats.UsageStatsService;
import gr.uoa.di.aginfra.data.analytics.visualization.model.stats.VisualizationUsageStats;
import gr.uoa.di.aginfra.data.analytics.visualization.service.controllers.VisualizationController;
import gr.uoa.di.aginfra.data.analytics.visualization.service.mappers.EntityMapper;
import gr.uoa.di.aginfra.data.analytics.visualization.service.vres.VREResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@CrossOrigin
@RequestMapping(value={"/usage"})
public class UsageController {
    private static final Logger logger = LogManager.getLogger(VisualizationController.class);
    protected static final String USAGE_BASE_PATH = "usage";
    private UsageStatsService usageService;
    private EntityMapper modelMapper;
    private VREResolver vreResolver;

    @Autowired
    public UsageController(UsageStatsService usageService, EntityMapper modelMapper, VREResolver vreResolver) {
        this.usageService = usageService;
        this.modelMapper = modelMapper;
        this.vreResolver = vreResolver;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<VisualizationUsageStats> get() throws Exception {
        logger.debug("Retrieving visualization usage statistics");
        VisualizationUsageStats stats = this.usageService.getStats(this.vreResolver.resolve());
        return ResponseEntity.ok((Object)stats);
    }
}

