/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.gcube.rest.index.common.entities.CollectionInfo;
import org.gcube.rest.index.common.search.SearchResult;
import org.gcube.rest.index.common.search.Search_Response;
import org.gcube.rest.index.publisher.IndexAdapterAPI;
import org.gcube.rest.index.publisher.RecordsResponse;
import org.gcube.rest.index.publisher.oaipmh.metadata.DCItem;
import org.gcube.rest.index.publisher.oaipmh.metadata.Metadata;
import org.gcube.rest.index.publisher.oaipmh.metadata.OAIDCItem;
import org.gcube.rest.index.publisher.oaipmh.repository.Record;
import org.gcube.rest.index.publisher.oaipmh.repository.Repository;
import org.gcube.rest.index.publisher.oaipmh.repository.ResumptionToken;
import org.gcube.rest.index.publisher.oaipmh.repository.SetSpec;
import org.gcube.rest.index.publisher.oaipmh.utils.DeletionEnum;
import org.gcube.rest.index.publisher.oaipmh.utils.UTCDatetime;
import org.gcube.rest.index.publisher.oaipmh.verbs.ListIdentifiers;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.BadResumptionTokenError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.CannotDisseminateFormatError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.IdDoesNotExistError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.NoMetadataFormatsError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.NoRecordsMatchError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.NoSetHierarchyError;

public class IndexRepository
extends Repository {
    private static final Logger logger = Logger.getLogger(IndexRepository.class);
    private IndexAdapterAPI indexAdapter;
    private final String language;
    private final int daysToExpireForResumptionToken;

    @Inject
    public IndexRepository(IndexAdapterAPI indexAdapter) {
        logger.debug((Object)"Create IndexRepository");
        InputStream stream = null;
        try {
            stream = IndexRepository.class.getClassLoader().getResourceAsStream("repository.properties");
        }
        catch (Exception e) {
            logger.fatal((Object)"cannot find repository.properties file");
        }
        Properties props = new Properties();
        try {
            props.load(stream);
        }
        catch (IOException ex) {
            logger.error((Object)"failed to load the properties file", (Throwable)ex);
        }
        this.repositoryName = props.getProperty("name").trim();
        this.language = props.getProperty("language").trim();
        this.daysToExpireForResumptionToken = Integer.parseInt(props.getProperty("daysToExpireForResumptionToken").trim());
        this.adminEmails = new ArrayList();
        for (String email : props.getProperty("adminEmails").split(",")) {
            this.adminEmails.add(email);
        }
        this.requestURL = props.getProperty("baseUrl").trim();
        this.indexAdapter = indexAdapter;
        this.hasResumptionTokenSupport = true;
        this.deletedRecord = DeletionEnum.NO;
        this.earliestDatestamp = "2013-10-04T14:58:31Z";
    }

    public List<Metadata> getMetadataFormats() throws NoMetadataFormatsError {
        ArrayList<Metadata> metaList = new ArrayList<Metadata>();
        metaList.add((Metadata)new OAIDCItem());
        return metaList;
    }

    public List<Metadata> getMetadataFormats(String identifier) throws NoMetadataFormatsError, IdDoesNotExistError {
        logger.debug((Object)"getMetadataFormats");
        try {
            Search_Response record = this.indexAdapter.getRecord(identifier);
            if (record == null || record.getSearchResultList().size() == 0) {
                throw new IdDoesNotExistError();
            }
            ArrayList<Metadata> metaList = new ArrayList<Metadata>();
            metaList.add((Metadata)new OAIDCItem());
            return metaList;
        }
        catch (Exception e) {
            throw new IdDoesNotExistError();
        }
    }

    public List<SetSpec> getSetSpecs() throws NoSetHierarchyError {
        logger.debug((Object)"getSetSpecs");
        List datasources = this.indexAdapter.getDatasources();
        ArrayList<SetSpec> specs = new ArrayList<SetSpec>();
        for (CollectionInfo datasource : datasources) {
            specs.add(this.createSetSpec(datasource));
        }
        if (specs.isEmpty()) {
            throw new NoSetHierarchyError();
        }
        return specs;
    }

    public List<SetSpec> getSetSpecs(ResumptionToken resumptionToken) throws NoSetHierarchyError, BadResumptionTokenError {
        throw new BadResumptionTokenError();
    }

    public Record getRecord(String id, String metadataPrefix) throws IdDoesNotExistError, CannotDisseminateFormatError {
        logger.debug((Object)"getRecord");
        try {
            if (!((Metadata)this.getMetadataFormats().get(0)).getPrefix().equals(metadataPrefix)) {
                throw new CannotDisseminateFormatError();
            }
        }
        catch (NoMetadataFormatsError e1) {
            throw new CannotDisseminateFormatError();
        }
        try {
            Search_Response indexRecord = this.indexAdapter.getRecord(id);
            Map mapAliases = this.indexAdapter.getMapAliases();
            if (indexRecord == null) {
                throw new IdDoesNotExistError();
            }
            return this.datasetToRecord((SearchResult)indexRecord.getSearchResultList().get(0), metadataPrefix, mapAliases);
        }
        catch (Exception e) {
            throw new IdDoesNotExistError();
        }
    }

    public RecordsResponse getRecords(String metadataPrefix, ListIdentifiers verb) throws CannotDisseminateFormatError, NoRecordsMatchError {
        logger.debug((Object)"getRecords");
        try {
            if (!((Metadata)this.getMetadataFormats().get(0)).getPrefix().equals(metadataPrefix)) {
                throw new CannotDisseminateFormatError();
            }
        }
        catch (NoMetadataFormatsError e1) {
            throw new CannotDisseminateFormatError();
        }
        try {
            Search_Response indexRecords = this.indexAdapter.getRecords(this.daysToExpireForResumptionToken);
            Map mapAliases = this.indexAdapter.getMapAliases();
            if (indexRecords.getSearchResultList().size() < 1) {
                throw new NoRecordsMatchError();
            }
            ArrayList<Record> records = new ArrayList<Record>();
            for (SearchResult indexRecord : indexRecords.getSearchResultList()) {
                Record r = this.datasetToRecord(indexRecord, metadataPrefix, mapAliases);
                records.add(r);
            }
            long completeListSize = this.indexAdapter.getRecordsNumber();
            if (completeListSize > (long)indexRecords.getSearchResultList().size()) {
                ResumptionToken token = new ResumptionToken();
                ZonedDateTime time = ZonedDateTime.now(ZoneOffset.UTC);
                time = time.plusDays(this.daysToExpireForResumptionToken);
                UTCDatetime expirationDate = new UTCDatetime(time);
                token.setCompleteListSize(completeListSize);
                token.setCursor(0);
                token.setScrollId(null);
                token.setExpirationDate(expirationDate);
                verb.setResumptionToken(token.getResumptionToken());
            }
            return new RecordsResponse(records, indexRecords.getScrollId());
        }
        catch (Exception e) {
            throw new NoRecordsMatchError();
        }
    }

    public RecordsResponse getRecords(UTCDatetime from, UTCDatetime until, String metadataPrefix) throws CannotDisseminateFormatError, NoRecordsMatchError {
        throw new NoRecordsMatchError();
    }

    public RecordsResponse getRecords(String metadataPrefix, ResumptionToken resumptionToken) throws CannotDisseminateFormatError, BadResumptionTokenError, NoRecordsMatchError {
        logger.debug((Object)"getRecords with resumptionToken");
        try {
            if (!((Metadata)this.getMetadataFormats().get(0)).getPrefix().equals(metadataPrefix)) {
                throw new CannotDisseminateFormatError();
            }
        }
        catch (NoMetadataFormatsError e1) {
            throw new CannotDisseminateFormatError();
        }
        try {
            Search_Response indexRecords = this.indexAdapter.getScrolledRecords(resumptionToken.getScrollId(), this.daysToExpireForResumptionToken);
            Map mapAliases = this.indexAdapter.getMapAliases();
            if (indexRecords.getSearchResultList().size() < 1) {
                throw new NoRecordsMatchError();
            }
            ArrayList<Record> records = new ArrayList<Record>();
            for (SearchResult indexRecord : indexRecords.getSearchResultList()) {
                Record r = this.datasetToRecord(indexRecord, metadataPrefix, mapAliases);
                records.add(r);
            }
            return new RecordsResponse(records, indexRecords.getScrollId());
        }
        catch (Exception e) {
            throw new NoRecordsMatchError();
        }
    }

    public RecordsResponse getRecords(String metadataPrefix, SetSpec set, ListIdentifiers verb) throws CannotDisseminateFormatError, NoSetHierarchyError {
        logger.debug((Object)"getRecords with set");
        try {
            if (!((Metadata)this.getMetadataFormats().get(0)).getPrefix().equals(metadataPrefix)) {
                throw new CannotDisseminateFormatError();
            }
        }
        catch (NoMetadataFormatsError e1) {
            throw new CannotDisseminateFormatError();
        }
        try {
            Search_Response indexRecords = this.indexAdapter.getRecords(set.toString(), this.daysToExpireForResumptionToken);
            Map mapAliases = this.indexAdapter.getMapAliases();
            if (indexRecords.getSearchResultList().size() < 1) {
                throw new NoSetHierarchyError();
            }
            ArrayList<Record> records = new ArrayList<Record>();
            for (SearchResult indexRecord : indexRecords.getSearchResultList()) {
                Record r = this.datasetToRecord(indexRecord, metadataPrefix, mapAliases);
                records.add(r);
            }
            long completeListSize = this.indexAdapter.getRecordsNumber(set.toString());
            if (completeListSize > (long)indexRecords.getSearchResultList().size()) {
                ResumptionToken token = new ResumptionToken();
                ZonedDateTime time = ZonedDateTime.now(ZoneOffset.UTC);
                time = time.plusDays(this.daysToExpireForResumptionToken);
                UTCDatetime expirationDate = new UTCDatetime(time);
                token.setCompleteListSize(completeListSize);
                token.setCursor(0);
                token.setScrollId(null);
                token.setExpirationDate(expirationDate);
                verb.setResumptionToken(token.getResumptionToken());
            }
            return new RecordsResponse(records, indexRecords.getScrollId());
        }
        catch (Exception e) {
            throw new NoSetHierarchyError();
        }
    }

    public RecordsResponse getRecords(String metadataPrefix, ResumptionToken resumptionToken, SetSpec set) throws CannotDisseminateFormatError, NoSetHierarchyError, BadResumptionTokenError {
        logger.debug((Object)"getRecords with set");
        logger.debug((Object)"getRecords with set and resumptionToken");
        try {
            if (!((Metadata)this.getMetadataFormats().get(0)).getPrefix().equals(metadataPrefix)) {
                throw new CannotDisseminateFormatError();
            }
        }
        catch (NoMetadataFormatsError e1) {
            throw new CannotDisseminateFormatError();
        }
        try {
            Search_Response indexRecords = this.indexAdapter.getRecords(set.toString(), resumptionToken.getScrollId(), this.daysToExpireForResumptionToken);
            Map mapAliases = this.indexAdapter.getMapAliases();
            if (indexRecords.getSearchResultList().size() < 1) {
                throw new NoSetHierarchyError();
            }
            ArrayList<Record> records = new ArrayList<Record>();
            for (SearchResult indexRecord : indexRecords.getSearchResultList()) {
                Record r = this.datasetToRecord(indexRecord, metadataPrefix, mapAliases);
                records.add(r);
            }
            return new RecordsResponse(records, indexRecords.getScrollId());
        }
        catch (Exception e) {
            throw new NoSetHierarchyError();
        }
    }

    public RecordsResponse getRecords(UTCDatetime from, UTCDatetime until, String metadataPrefix, ResumptionToken resumptionToken, SetSpec set) throws CannotDisseminateFormatError, NoRecordsMatchError, NoSetHierarchyError, BadResumptionTokenError {
        throw new NoRecordsMatchError();
    }

    private Record datasetToRecord(SearchResult searchRecord, String metadataPrefix, Map<String, Map<String, String>> mapAliases) throws Exception {
        logger.debug((Object)"datasetToRecord");
        if (searchRecord == null) {
            return null;
        }
        Record record = new Record(searchRecord.getRecordId(), metadataPrefix);
        ArrayList<SetSpec> setSpecs = new ArrayList<SetSpec>();
        CollectionInfo datasource = this.indexAdapter.getDatasource(searchRecord.getCollectionId());
        setSpecs.add(this.createSetSpec(datasource));
        Map results = searchRecord.getSource();
        Map dcResults = this.convertFromAliasFieldsToDcFields(searchRecord, results, mapAliases);
        record.setSetSpecs(setSpecs);
        OAIDCItem dc = new OAIDCItem();
        dc.setTitle((String)dcResults.get("dc:title"));
        dc.setCreator((String)dcResults.get("dc:creator"));
        if (dcResults.get("dc:subject") != null) {
            List<String> dcSubject = Arrays.asList(((String)dcResults.get("dc:subject")).replaceAll("\\[", "").replaceAll("\\]", "").split("\\s*,\\s*"));
            dc.setSubjects(dcSubject);
        }
        dc.setDescription((String)dcResults.get("dc:description"));
        dc.setPublisher((String)dcResults.get("dc:publisher"));
        dc.setContributor((String)dcResults.get("dc:contributor"));
        dc.setDate((String)dcResults.get("dc:date"));
        dc.setType((String)dcResults.get("dc:type"));
        if (dcResults.get("dc:format") != null) {
            List<String> dcFormats = Arrays.asList(((String)dcResults.get("dc:format")).replaceAll("\\[", "").replaceAll("\\]", "").split("\\s*,\\s*"));
            dc.setFormats(dcFormats);
        }
        if (dcResults.get("dc:source") != null) {
            List<String> dcSources = Arrays.asList(((String)dcResults.get("dc:source")).replaceAll("\\[", "").replaceAll("\\]", "").split("\\s*,\\s*"));
            dc.setSources(dcSources);
        }
        dc.setIdentifier((String)dcResults.get("dc:identifier"));
        dc.setLanguage((String)dcResults.get("dc:language"));
        dc.setRights((String)dcResults.get("dc:rights"));
        record.setMetadata((Metadata)dc);
        return record;
    }

    private Map<String, String> convertFromAliasFieldsToDcFields(SearchResult searchResponse, Map<String, Object> aliasSource, Map<String, Map<String, String>> mapAliases) {
        HashMap<String, String> dcSource = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : aliasSource.entrySet()) {
            if (mapAliases.get(searchResponse.getCollectionId()).containsKey(entry.getKey())) {
                dcSource.put(mapAliases.get(searchResponse.getCollectionId()).get(entry.getKey()), entry.getValue().toString());
                continue;
            }
            dcSource.put(entry.getKey(), entry.getValue().toString());
        }
        return dcSource;
    }

    public String getDate(Map<String, String> dcResults) {
        logger.debug((Object)"Get_date");
        String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS z";
        TimeZone utc = TimeZone.getTimeZone("UTC");
        SimpleDateFormat isoFormatter = new SimpleDateFormat(ISO_FORMAT);
        isoFormatter.setTimeZone(utc);
        if (dcResults.get("dc:date") != null) {
            Timestamp date = Timestamp.valueOf(dcResults.get("dc:date"));
            ZonedDateTime zonedDateTime = ZonedDateTime.of(date.toLocalDateTime(), ZoneOffset.UTC);
            return zonedDateTime.toString();
        }
        return null;
    }

    public SetSpec createSetSpec(CollectionInfo datasource) {
        logger.debug((Object)"createSetSpec");
        SetSpec set = new SetSpec(datasource.getId(), datasource.getTitle());
        OAIDCItem dc = new OAIDCItem();
        dc.setDescription(datasource.getDescription());
        set.setSetDescription((DCItem)dc);
        return set;
    }

    public void closeConnection() {
    }
}

