/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher.oaipmh.repository;

import java.util.List;
import org.gcube.rest.index.publisher.RecordsResponse;
import org.gcube.rest.index.publisher.oaipmh.metadata.Metadata;
import org.gcube.rest.index.publisher.oaipmh.repository.Record;
import org.gcube.rest.index.publisher.oaipmh.repository.ResumptionToken;
import org.gcube.rest.index.publisher.oaipmh.repository.SetSpec;
import org.gcube.rest.index.publisher.oaipmh.utils.DeletionEnum;
import org.gcube.rest.index.publisher.oaipmh.utils.UTCDatetime;
import org.gcube.rest.index.publisher.oaipmh.verbs.ListIdentifiers;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.BadResumptionTokenError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.CannotDisseminateFormatError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.IdDoesNotExistError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.NoMetadataFormatsError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.NoRecordsMatchError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.NoSetHierarchyError;

public abstract class Repository {
    protected String requestURL;
    protected String repositoryName;
    protected String earliestDatestamp;
    protected String granularity = "YYYY-MM-DDThh:mm:ssZ";
    protected List<String> adminEmails;
    protected String compression = null;
    protected List<String> descriptions = null;
    protected boolean hasResumptionTokenSupport = false;
    protected DeletionEnum deletedRecord = DeletionEnum.NO;

    public void setHasResumptionTokenSupport(boolean hasResumptionTokenSupport) {
        this.hasResumptionTokenSupport = hasResumptionTokenSupport;
    }

    public boolean hasResumptionTokenSupport() {
        return this.hasResumptionTokenSupport;
    }

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setEarliestDatestamp(String earliestDatestamp) {
        this.earliestDatestamp = earliestDatestamp;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public void setAdminEmails(List<String> adminEmails) {
        this.adminEmails = adminEmails;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public void setDescriptions(List<String> descriptions) {
        this.descriptions = descriptions;
    }

    public void setDeletedRecord(DeletionEnum deletedRecord) {
        this.deletedRecord = deletedRecord;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getEarliestDatestamp() {
        return this.earliestDatestamp;
    }

    public String getDeletedRecord() {
        return this.deletedRecord.toString();
    }

    public String getGranularity() {
        return this.granularity;
    }

    public List<String> getAdminEmails() {
        return this.adminEmails;
    }

    public String getCompression() {
        return this.compression;
    }

    public List<String> getDescriptions() {
        return this.descriptions;
    }

    public abstract List<Metadata> getMetadataFormats() throws NoMetadataFormatsError;

    public abstract List<Metadata> getMetadataFormats(String var1) throws NoMetadataFormatsError, IdDoesNotExistError;

    public abstract List<SetSpec> getSetSpecs() throws NoSetHierarchyError;

    public abstract List<SetSpec> getSetSpecs(ResumptionToken var1) throws NoSetHierarchyError, BadResumptionTokenError;

    public abstract Record getRecord(String var1, String var2) throws IdDoesNotExistError, CannotDisseminateFormatError;

    public abstract RecordsResponse getRecords(String var1, ListIdentifiers var2) throws CannotDisseminateFormatError, NoRecordsMatchError;

    public abstract RecordsResponse getRecords(UTCDatetime var1, UTCDatetime var2, String var3) throws CannotDisseminateFormatError, NoRecordsMatchError;

    public abstract RecordsResponse getRecords(String var1, ResumptionToken var2) throws CannotDisseminateFormatError, BadResumptionTokenError, NoRecordsMatchError;

    public abstract RecordsResponse getRecords(String var1, SetSpec var2, ListIdentifiers var3) throws CannotDisseminateFormatError, NoSetHierarchyError;

    public abstract RecordsResponse getRecords(String var1, ResumptionToken var2, SetSpec var3) throws CannotDisseminateFormatError, NoSetHierarchyError, BadResumptionTokenError;

    public abstract RecordsResponse getRecords(UTCDatetime var1, UTCDatetime var2, String var3, ResumptionToken var4, SetSpec var5) throws CannotDisseminateFormatError, NoRecordsMatchError, NoSetHierarchyError, BadResumptionTokenError;

    public abstract void closeConnection();
}

