/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher.oaipmh.verbs;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.gcube.rest.index.publisher.oaipmh.repository.Record;
import org.gcube.rest.index.publisher.oaipmh.repository.Repository;
import org.gcube.rest.index.publisher.oaipmh.utils.XMLUtils;
import org.gcube.rest.index.publisher.oaipmh.verbs.Verb;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.BadArgumentError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.CannotDisseminateFormatError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.ErrorCondition;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.IdDoesNotExistError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GetRecord
extends Verb {
    protected static Logger logger = Logger.getLogger((String)GetRecord.class.getName());
    private String requestURL;
    private String identifier;
    private String metadataPrefix;

    public void initializeRootElement() {
        logger.debug((Object)"initializeRootElement");
        super.initializeRootElement();
        Element rootElement = this.xmlDocument.getDocumentElement();
        Element requestElement = this.xmlDocument.createElement("request");
        requestElement.setAttribute("verb", "GetRecord");
        requestElement.setAttribute("identifier", this.identifier);
        requestElement.setAttribute("metadataPrefix", this.metadataPrefix);
        requestElement.setTextContent(this.requestURL);
        rootElement.appendChild(requestElement);
    }

    public String response(Repository repository) {
        logger.debug((Object)"response");
        this.initializeRootElement();
        if (this.hasErrors()) {
            this.appendErrorNodes();
        } else {
            Element rootElement = this.xmlDocument.getDocumentElement();
            Element getRecordElement = this.xmlDocument.createElement("GetRecord");
            try {
                Record record = repository.getRecord(this.identifier, this.metadataPrefix);
                getRecordElement.appendChild(this.xmlDocument.importNode(record.getXMLElement(), true));
                rootElement.appendChild(getRecordElement);
            }
            catch (IdDoesNotExistError e) {
                rootElement.appendChild(XMLUtils.errorToXML((ErrorCondition)e, (Document)this.xmlDocument));
                logger.info((Object)("ErrorCondition: " + e.getCode()));
            }
            catch (CannotDisseminateFormatError e) {
                rootElement.appendChild(XMLUtils.errorToXML((ErrorCondition)e, (Document)this.xmlDocument));
                logger.info((Object)("ErrorCondition: " + e.getCode()));
            }
        }
        try {
            return XMLUtils.transformDocumentToString((Document)this.xmlDocument);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public void setAttributes(UriInfo req) {
        logger.debug((Object)"setAttributes");
        this.requestURL = req.getAbsolutePath().toString();
        MultivaluedHashMap parameters = new MultivaluedHashMap();
        for (Map.Entry queryParam : req.getQueryParameters().entrySet()) {
            for (String queryParamValue : (List)queryParam.getValue()) {
                parameters.add(queryParam.getKey(), (Object)queryParamValue);
            }
        }
        if (!parameters.containsKey((Object)"metadataPrefix")) {
            this.addError((ErrorCondition)new BadArgumentError("There was no metadataPrefix"));
            return;
        }
        this.metadataPrefix = (String)parameters.getFirst((Object)"metadataPrefix");
        parameters.remove((Object)"metadataPrefix");
        if (!parameters.containsKey((Object)"identifier")) {
            this.addError((ErrorCondition)new BadArgumentError("There was no identifier"));
            return;
        }
        this.identifier = (String)parameters.getFirst((Object)"identifier");
        parameters.remove((Object)"identifier");
        parameters.remove((Object)"verb");
        if (parameters.size() > 0) {
            this.addError((ErrorCondition)new BadArgumentError("There are extra parameters"));
        }
    }
}

