/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher.oaipmh.verbs;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.gcube.rest.index.publisher.oaipmh.repository.Repository;
import org.gcube.rest.index.publisher.oaipmh.utils.XMLUtils;
import org.gcube.rest.index.publisher.oaipmh.verbs.Verb;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.BadArgumentError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.ErrorCondition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Identify
extends Verb {
    protected static Logger logger = Logger.getLogger((String)Identify.class.getName());
    private String requestURL;

    public void initializeRootElement() {
        logger.debug((Object)"initializeRootElement");
        super.initializeRootElement();
        Element rootElement = this.xmlDocument.getDocumentElement();
        Element requestElement = this.xmlDocument.createElement("request");
        requestElement.setAttribute("verb", "Identify");
        requestElement.setTextContent(this.requestURL);
        rootElement.appendChild(requestElement);
    }

    public String response(Repository repository) {
        logger.debug((Object)"response");
        this.initializeRootElement();
        if (this.hasErrors()) {
            this.appendErrorNodes();
        } else {
            Element rootElement = this.xmlDocument.getDocumentElement();
            Element identifyElement = this.xmlDocument.createElement("Identify");
            Element repositoryNameElement = this.xmlDocument.createElement("repositoryName");
            repositoryNameElement.setTextContent(repository.getRepositoryName());
            identifyElement.appendChild(repositoryNameElement);
            Element baseUrlElement = this.xmlDocument.createElement("baseURL");
            baseUrlElement.setTextContent(repository.getRequestURL());
            identifyElement.appendChild(baseUrlElement);
            Element protocolVersionElement = this.xmlDocument.createElement("protocolVersion");
            protocolVersionElement.setTextContent("2.0");
            identifyElement.appendChild(protocolVersionElement);
            Element earliestDatestampElement = this.xmlDocument.createElement("earliestDatestamp");
            earliestDatestampElement.setTextContent(repository.getEarliestDatestamp());
            identifyElement.appendChild(earliestDatestampElement);
            Element deletedRecordElement = this.xmlDocument.createElement("deletedRecord");
            deletedRecordElement.setTextContent(repository.getDeletedRecord());
            identifyElement.appendChild(deletedRecordElement);
            Element granularityElement = this.xmlDocument.createElement("granularity");
            granularityElement.setTextContent(repository.getGranularity());
            identifyElement.appendChild(granularityElement);
            for (String email : repository.getAdminEmails()) {
                Element emailElement = this.xmlDocument.createElement("adminEmail");
                emailElement.setTextContent(email);
                identifyElement.appendChild(emailElement);
            }
            if (repository.getCompression() != null) {
                Element compressionElement = this.xmlDocument.createElement("compression");
                compressionElement.setTextContent(repository.getCompression());
                identifyElement.appendChild(compressionElement);
            }
            if (repository.getDescriptions() != null) {
                for (String descr : repository.getDescriptions()) {
                    Element descriptionElement = this.xmlDocument.createElement("description");
                    descriptionElement.setTextContent(descr);
                    identifyElement.appendChild(descriptionElement);
                }
            }
            rootElement.appendChild(identifyElement);
        }
        try {
            return XMLUtils.transformDocumentToString((Document)this.xmlDocument);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public void setAttributes(UriInfo req) {
        logger.debug((Object)"setAttributes");
        this.requestURL = req.getAbsolutePath().toString();
        MultivaluedHashMap parameters = new MultivaluedHashMap();
        for (Map.Entry queryParam : req.getQueryParameters().entrySet()) {
            for (String queryParamValue : (List)queryParam.getValue()) {
                parameters.add(queryParam.getKey(), (Object)queryParamValue);
            }
        }
        parameters.remove((Object)"verb");
        if (parameters.size() > 0) {
            this.addError((ErrorCondition)new BadArgumentError("There are extra parameters"));
        }
    }
}

