/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher.oaipmh.verbs;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.gcube.rest.index.publisher.oaipmh.metadata.Metadata;
import org.gcube.rest.index.publisher.oaipmh.repository.Repository;
import org.gcube.rest.index.publisher.oaipmh.utils.XMLUtils;
import org.gcube.rest.index.publisher.oaipmh.verbs.Verb;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.BadArgumentError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.ErrorCondition;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.IdDoesNotExistError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.NoMetadataFormatsError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ListMetadataFormats
extends Verb {
    protected static Logger logger = Logger.getLogger((String)ListMetadataFormats.class.getName());
    private String identifier = null;
    private String requestURL;

    public void initializeRootElement() {
        logger.debug((Object)"initializeRootElement");
        super.initializeRootElement();
        Element rootElement = this.xmlDocument.getDocumentElement();
        Element requestElement = this.xmlDocument.createElement("request");
        requestElement.setAttribute("verb", "ListMetadataFormats");
        if (this.identifier != null) {
            requestElement.setAttribute("identifier", this.identifier);
        }
        requestElement.setTextContent(this.requestURL);
        rootElement.appendChild(requestElement);
    }

    public String response(Repository repository) {
        logger.debug((Object)"response");
        this.initializeRootElement();
        if (this.hasErrors()) {
            this.appendErrorNodes();
        } else {
            Element rootElement = this.xmlDocument.getDocumentElement();
            List metadataFormats = null;
            try {
                metadataFormats = this.identifier == null ? repository.getMetadataFormats() : repository.getMetadataFormats(this.identifier);
            }
            catch (NoMetadataFormatsError e) {
                this.addError((ErrorCondition)e);
            }
            catch (IdDoesNotExistError e) {
                this.addError((ErrorCondition)e);
            }
            if (this.hasErrors()) {
                this.appendErrorNodes();
            } else {
                Element listMetadataFormatsElement = this.xmlDocument.createElement("ListMetadataFormats");
                for (Metadata metadataFormat : metadataFormats) {
                    listMetadataFormatsElement.appendChild(this.xmlDocument.importNode(metadataFormat.getFormatXMLElement(), true));
                }
                rootElement.appendChild(listMetadataFormatsElement);
            }
        }
        try {
            return XMLUtils.transformDocumentToString((Document)this.xmlDocument);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public void setAttributes(UriInfo req) {
        logger.debug((Object)"setAttributes");
        this.requestURL = req.getAbsolutePath().toString();
        MultivaluedHashMap parameters = new MultivaluedHashMap();
        for (Map.Entry queryParam : req.getQueryParameters().entrySet()) {
            for (String queryParamValue : (List)queryParam.getValue()) {
                parameters.add(queryParam.getKey(), (Object)queryParamValue);
            }
        }
        if (parameters.containsKey((Object)"identifier")) {
            this.identifier = (String)parameters.getFirst((Object)"identifier");
            parameters.remove((Object)"identifier");
        }
        parameters.remove((Object)"verb");
        if (parameters.size() > 0) {
            this.addError((ErrorCondition)new BadArgumentError());
        }
    }
}

