/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher.oaipmh.verbs;

import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.rest.index.publisher.RecordsResponse;
import org.gcube.rest.index.publisher.oaipmh.repository.FlowControl;
import org.gcube.rest.index.publisher.oaipmh.repository.Record;
import org.gcube.rest.index.publisher.oaipmh.repository.Repository;
import org.gcube.rest.index.publisher.oaipmh.repository.RepositoryRegistrationException;
import org.gcube.rest.index.publisher.oaipmh.repository.ResumptionToken;
import org.gcube.rest.index.publisher.oaipmh.utils.XMLUtils;
import org.gcube.rest.index.publisher.oaipmh.verbs.ListIdentifiers;
import org.gcube.rest.index.publisher.oaipmh.verbs.Verb;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.BadResumptionTokenError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.ErrorCondition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ListRecords
extends ListIdentifiers {
    protected static Logger logger = Logger.getLogger((String)ListRecords.class.getName());

    public void initializeRootElement() {
        logger.debug((Object)"initializeRootElement");
        super.initializeRootElement();
        Element rootElement = this.xmlDocument.getDocumentElement();
        Element requestElement = this.xmlDocument.createElement("request");
        requestElement.setAttribute("verb", "ListRecords");
        if (this.metadataPrefix != null) {
            requestElement.setAttribute("metadataPrefix", this.metadataPrefix);
        }
        if (this.from != null) {
            requestElement.setAttribute("from", this.from.getDatetimeAsString());
        }
        if (this.until != null) {
            requestElement.setAttribute("until", this.until.getDatetimeAsString());
        }
        if (this.set != null) {
            requestElement.setAttribute("set", this.set.toString());
        }
        if (this.resumptionToken != null) {
            requestElement.setAttribute("resumptionToken", this.resumptionToken);
            FlowControl flowControl = FlowControl.getInstance();
            ResumptionToken token = flowControl.getResumptionToken(this.resumptionToken);
            this.metadataPrefix = token.getMetadataPrefix();
            this.from = token.getFrom();
            this.until = token.getUntil();
            this.set = token.getSet();
        }
        requestElement.setTextContent(this.requestURL);
        rootElement.appendChild(requestElement);
    }

    public String response(Repository repository) {
        logger.debug((Object)"response");
        this.initializeRootElement();
        if (this.hasErrors()) {
            this.appendErrorNodes();
        } else {
            List records;
            Element rootElement = this.xmlDocument.getDocumentElement();
            RecordsResponse recordsResponse = null;
            try {
                recordsResponse = this.getRecords(repository);
                records = recordsResponse.getRecords();
            }
            catch (RepositoryRegistrationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                records = null;
            }
            if (this.hasErrors()) {
                this.appendErrorNodes();
            } else {
                FlowControl flowControl;
                ResumptionToken token;
                Element listIdentifiersElement = this.xmlDocument.createElement("ListRecords");
                for (Record record : records) {
                    listIdentifiersElement.appendChild(this.xmlDocument.importNode(record.getXMLElement(), true));
                }
                if (this.resumptionToken != null && (token = (flowControl = FlowControl.getInstance()).getResumptionToken(this.resumptionToken)) != null) {
                    listIdentifiersElement.appendChild(this.xmlDocument.importNode(token.getXMLElement(records.size()), true));
                    try {
                        Verb.handleResumptionToken((ResumptionToken)token, (int)records.size(), (String)recordsResponse.getScrollId());
                    }
                    catch (BadResumptionTokenError ex) {
                        this.addError((ErrorCondition)ex);
                        logger.info((Object)ex);
                    }
                    if (token.getMetadataPrefix().equals("")) {
                        token.setFrom(this.from);
                        token.setMetadataPrefix(this.metadataPrefix);
                        token.setSet(this.set);
                        token.setUntil(this.until);
                    }
                }
                rootElement.appendChild(listIdentifiersElement);
            }
        }
        try {
            return XMLUtils.transformDocumentToString((Document)this.xmlDocument);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }
}

