/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher.oaipmh.verbs;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.gcube.rest.index.publisher.oaipmh.repository.FlowControl;
import org.gcube.rest.index.publisher.oaipmh.repository.Repository;
import org.gcube.rest.index.publisher.oaipmh.repository.ResumptionToken;
import org.gcube.rest.index.publisher.oaipmh.utils.UTCDatetime;
import org.gcube.rest.index.publisher.oaipmh.utils.XMLUtils;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.BadResumptionTokenError;
import org.gcube.rest.index.publisher.oaipmh.verbs.errors.ErrorCondition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Verb {
    protected static Logger logger = Logger.getLogger((String)Verb.class.getName());
    private List<ErrorCondition> errors = new ArrayList();
    protected Document xmlDocument;

    public Verb() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.xmlDocument = builder.newDocument();
            this.xmlDocument.setXmlStandalone(true);
            this.xmlDocument.setXmlVersion("1.0");
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void initializeRootElement() {
        logger.debug((Object)"initializeRootElement");
        Element rootElement = this.xmlDocument.createElementNS("http://www.openarchives.org/OAI/2.0/", "OAI-PMH");
        rootElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.openarchives.org/OAI/2.0/ http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd");
        Element responseDateElement = this.xmlDocument.createElement("responseDate");
        responseDateElement.setTextContent(UTCDatetime.now());
        rootElement.appendChild(responseDateElement);
        this.xmlDocument.appendChild(rootElement);
    }

    public void appendErrorNodes() {
        for (ErrorCondition error : this.getErrors()) {
            this.xmlDocument.getDocumentElement().appendChild(XMLUtils.errorToXML((ErrorCondition)error, (Document)this.xmlDocument));
        }
    }

    protected void addError(ErrorCondition error) {
        this.errors.add(error);
    }

    public List<ErrorCondition> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    protected static void handleResumptionToken(ResumptionToken resumptionToken, int returnedListFromRepositorySize, String scrollId) throws BadResumptionTokenError {
        logger.debug((Object)"handleResumptionToken");
        FlowControl flowControl = FlowControl.getInstance();
        if ((long)(resumptionToken.getCursor() + returnedListFromRepositorySize) >= resumptionToken.getCompleteListSize()) {
            flowControl.unregister(resumptionToken);
        } else {
            resumptionToken.setCursor(resumptionToken.getCursor() + returnedListFromRepositorySize);
            resumptionToken.setScrollId(scrollId);
        }
    }

    public abstract String response(Repository var1);

    public abstract void setAttributes(UriInfo var1);
}

