/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.publisher.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.gcube.rest.index.publisher.IndexAdapterAPI;
import org.gcube.rest.index.publisher.IndexRepository;
import org.gcube.rest.index.publisher.oaipmh.repository.Repository;
import org.gcube.rest.index.publisher.oaipmh.repository.RepositoryResponse;

@Path(value="")
public class OAIPMHRest {
    Logger logger = Logger.getLogger((String)OAIPMHRest.class.getName());
    IndexRepository repository;

    public OAIPMHRest() {
        this.logger.debug((Object)"Create OAIPMHResource");
        InputStream stream = null;
        try {
            stream = IndexRepository.class.getClassLoader().getResourceAsStream("index.properties");
        }
        catch (Exception e) {
            this.logger.fatal((Object)"cannot find index.properties file");
        }
        Properties props = new Properties();
        try {
            props.load(stream);
        }
        catch (IOException ex) {
            this.logger.error(null, (Throwable)ex);
        }
        String scope = props.getProperty("scope").trim();
        int limit = Integer.parseInt(props.getProperty("limit").trim());
        IndexAdapterAPI indexAdapter = new IndexAdapterAPI(limit);
        indexAdapter.createClient(scope);
        this.repository = new IndexRepository(indexAdapter);
    }

    @GET
    @Produces(value={"text/xml"})
    public Response query(@Context UriInfo request) {
        this.logger.debug((Object)"oai publisher was called");
        String response = RepositoryResponse.request((UriInfo)request).response((Repository)this.repository).build();
        return Response.ok((Object)response).build();
    }
}

