/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.analytics;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.PrelocatedRequest;
import com.couchbase.client.core.message.analytics.AnalyticsRequest;
import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.net.InetAddress;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class GenericAnalyticsRequest
extends AbstractCouchbaseRequest
implements AnalyticsRequest,
PrelocatedRequest {
    public static final int NO_PRIORITY = 0;
    private final String query;
    private final boolean jsonFormat;
    private final InetAddress targetNode;
    private final int priority;

    protected GenericAnalyticsRequest(String query, boolean jsonFormat, String bucket, String username, String password, InetAddress targetNode, int priority) {
        super(bucket, username, password);
        this.query = query;
        this.jsonFormat = jsonFormat;
        this.targetNode = targetNode;
        this.priority = priority;
    }

    @Override
    protected void afterSpanSet(Span span) {
        span.setTag(Tags.PEER_SERVICE.getKey(), "analytics");
    }

    public String query() {
        return this.query;
    }

    public int priority() {
        return this.priority;
    }

    public boolean isJsonFormat() {
        return this.jsonFormat;
    }

    @Override
    public InetAddress sendTo() {
        return this.targetNode;
    }

    public static GenericAnalyticsRequest simpleStatement(String statement, String bucket, String password) {
        return new GenericAnalyticsRequest(statement, false, bucket, bucket, password, null, 0);
    }

    public static GenericAnalyticsRequest simpleStatement(String statement, String bucket, String username, String password) {
        return new GenericAnalyticsRequest(statement, false, bucket, username, password, null, 0);
    }

    public static GenericAnalyticsRequest jsonQuery(String jsonQuery, String bucket, String username, String password, int priority) {
        return new GenericAnalyticsRequest(jsonQuery, true, bucket, username, password, null, priority);
    }

    public static GenericAnalyticsRequest jsonQuery(String jsonQuery, String bucket, String username, String password) {
        return GenericAnalyticsRequest.jsonQuery(jsonQuery, bucket, username, password, 0);
    }

    public static GenericAnalyticsRequest jsonQuery(String jsonQuery, String bucket, String username, String password, InetAddress targetNode) {
        return new GenericAnalyticsRequest(jsonQuery, true, bucket, username, password, targetNode, 0);
    }

    @Override
    public String path() {
        return "/analytics/service";
    }
}

