/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.kv.subdoc.simple;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.kv.subdoc.BinarySubdocMutationRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.AbstractSubdocRequest;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import rx.subjects.AsyncSubject;
import rx.subjects.Subject;

@InterfaceStability.Committed
@InterfaceAudience.Public
public abstract class AbstractSubdocMutationRequest
extends AbstractSubdocRequest
implements BinarySubdocMutationRequest {
    private final int expiration;
    private final ByteBuf fragment;
    private boolean createIntermediaryPath;
    private boolean xattr;
    private boolean upsertDocument;
    private boolean insertDocument;
    private long cas;
    private boolean expandMacros;

    protected AbstractSubdocMutationRequest(String key, String path, ByteBuf fragment, String bucket, int expiration, long cas) {
        this(key, path, fragment, bucket, expiration, cas, AsyncSubject.create());
    }

    protected AbstractSubdocMutationRequest(String key, String path, ByteBuf fragment, String bucket, int expiration, long cas, Subject<CouchbaseResponse, CouchbaseResponse> observable) {
        super(key, path, bucket, observable, fragment);
        this.expiration = expiration;
        this.fragment = fragment;
        this.cas = cas;
    }

    @Override
    public int expiration() {
        return this.expiration;
    }

    @Override
    public ByteBuf fragment() {
        return this.fragment;
    }

    @Override
    public boolean createIntermediaryPath() {
        return this.createIntermediaryPath;
    }

    public void createIntermediaryPath(boolean createIntermediaryPath) {
        this.createIntermediaryPath = createIntermediaryPath;
    }

    @Override
    public boolean xattr() {
        return this.xattr;
    }

    public void xattr(boolean xattr) {
        this.xattr = xattr;
    }

    @Override
    public boolean expandMacros() {
        return this.expandMacros;
    }

    public void expandMacros(boolean expandMacros) {
        this.expandMacros = expandMacros;
    }

    @Override
    public long cas() {
        return this.cas;
    }

    @Override
    public boolean createDocument() {
        return this.upsertDocument;
    }

    public void createDocument(boolean createDocument) {
        if (this.insertDocument && createDocument) {
            throw new IllegalArgumentException("Invalid to set createDocument to true along with insertDocument");
        }
        this.upsertDocument = createDocument;
    }

    @Override
    public boolean upsertDocument() {
        return this.upsertDocument;
    }

    public void upsertDocument(boolean upsertDocument) {
        if (this.insertDocument && upsertDocument) {
            throw new IllegalArgumentException("Invalid to set upsertDocument to true along with insertDocument");
        }
        this.upsertDocument = upsertDocument;
    }

    @Override
    public boolean insertDocument() {
        return this.insertDocument;
    }

    public void insertDocument(boolean insertDocument) {
        if (this.upsertDocument && insertDocument) {
            throw new IllegalArgumentException("Invalid to set insertDocument to true along with upsertDocument");
        }
        this.insertDocument = insertDocument;
    }
}

