/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.metrics;

import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.event.metrics.LatencyMetric;
import com.couchbase.client.core.event.metrics.NetworkLatencyMetricsEvent;
import com.couchbase.client.core.metrics.AbstractLatencyMetricsCollector;
import com.couchbase.client.core.metrics.LatencyMetricsCollectorConfig;
import com.couchbase.client.core.metrics.LatencyMetricsIdentifier;
import com.couchbase.client.core.metrics.NetworkLatencyMetricsIdentifier;
import com.couchbase.client.deps.org.HdrHistogram.Histogram;
import com.couchbase.client.deps.org.LatencyUtils.LatencyStats;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;

public class NetworkLatencyMetricsCollector
extends AbstractLatencyMetricsCollector<NetworkLatencyMetricsIdentifier, NetworkLatencyMetricsEvent> {
    private final TimeUnit targetUnit;
    private final Double[] targetPercentiles;

    public NetworkLatencyMetricsCollector(EventBus eventBus, Scheduler scheduler, LatencyMetricsCollectorConfig config) {
        super(eventBus, scheduler, config);
        this.targetUnit = config.targetUnit();
        this.targetPercentiles = config.targetPercentiles();
    }

    @Override
    protected NetworkLatencyMetricsEvent generateLatencyMetricsEvent(Map<NetworkLatencyMetricsIdentifier, LatencyStats> latencyMetrics) {
        TreeMap<NetworkLatencyMetricsIdentifier, LatencyMetric> sortedMetrics = new TreeMap<NetworkLatencyMetricsIdentifier, LatencyMetric>();
        for (Map.Entry<NetworkLatencyMetricsIdentifier, LatencyStats> entry : latencyMetrics.entrySet()) {
            Histogram histogram = entry.getValue().getIntervalHistogram();
            if (histogram.getTotalCount() == 0L) {
                this.remove((LatencyMetricsIdentifier)entry.getKey());
                continue;
            }
            TreeMap<Double, Long> percentiles = new TreeMap<Double, Long>();
            Double[] doubleArray = this.targetPercentiles;
            int n = doubleArray.length;
            for (int i = 0; i < n; ++i) {
                double targetPercentile = doubleArray[i];
                percentiles.put(targetPercentile, this.targetUnit.convert(histogram.getValueAtPercentile(targetPercentile), TimeUnit.NANOSECONDS));
            }
            sortedMetrics.put(entry.getKey(), new LatencyMetric(this.targetUnit.convert(histogram.getMinValue(), TimeUnit.NANOSECONDS), this.targetUnit.convert(histogram.getMaxValue(), TimeUnit.NANOSECONDS), histogram.getTotalCount(), percentiles, this.targetUnit));
        }
        return new NetworkLatencyMetricsEvent((Map<NetworkLatencyMetricsIdentifier, LatencyMetric>)sortedMetrics);
    }
}

