/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.CompositeException;
import rx.plugins.RxJavaHooks;
import rx.subscriptions.CompositeSubscription;

public final class CompletableOnSubscribeMerge
implements Completable.OnSubscribe {
    final Observable<Completable> source;
    final int maxConcurrency;
    final boolean delayErrors;

    public CompletableOnSubscribeMerge(Observable<? extends Completable> source, int maxConcurrency, boolean delayErrors) {
        this.source = source;
        this.maxConcurrency = maxConcurrency;
        this.delayErrors = delayErrors;
    }

    @Override
    public void call(CompletableSubscriber s) {
        CompletableMergeSubscriber parent = new CompletableMergeSubscriber(s, this.maxConcurrency, this.delayErrors);
        s.onSubscribe(parent);
        this.source.unsafeSubscribe(parent);
    }

    public static Throwable collectErrors(Queue<Throwable> q) {
        Throwable t;
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while ((t = q.poll()) != null) {
            list.add(t);
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (Throwable)list.get(0);
        }
        return new CompositeException(list);
    }

    static final class CompletableMergeSubscriber
    extends Subscriber<Completable> {
        final CompletableSubscriber actual;
        final CompositeSubscription set;
        final boolean delayErrors;
        volatile boolean done;
        final AtomicReference<Queue<Throwable>> errors;
        final AtomicBoolean once;
        final AtomicInteger wip;

        public CompletableMergeSubscriber(CompletableSubscriber actual, int maxConcurrency, boolean delayErrors) {
            this.actual = actual;
            this.delayErrors = delayErrors;
            this.set = new CompositeSubscription();
            this.wip = new AtomicInteger(1);
            this.once = new AtomicBoolean();
            this.errors = new AtomicReference();
            if (maxConcurrency == Integer.MAX_VALUE) {
                this.request(Long.MAX_VALUE);
            } else {
                this.request(maxConcurrency);
            }
        }

        Queue<Throwable> getOrCreateErrors() {
            Queue<Throwable> q = this.errors.get();
            if (q != null) {
                return q;
            }
            q = new ConcurrentLinkedQueue<Throwable>();
            if (this.errors.compareAndSet(null, q)) {
                return q;
            }
            return this.errors.get();
        }

        @Override
        public void onNext(Completable t) {
            if (this.done) {
                return;
            }
            this.wip.getAndIncrement();
            t.unsafeSubscribe(new CompletableSubscriber(){
                Subscription d;
                boolean innerDone;

                @Override
                public void onSubscribe(Subscription d) {
                    this.d = d;
                    CompletableMergeSubscriber.this.set.add(d);
                }

                @Override
                public void onError(Throwable e) {
                    if (this.innerDone) {
                        RxJavaHooks.onError(e);
                        return;
                    }
                    this.innerDone = true;
                    CompletableMergeSubscriber.this.set.remove(this.d);
                    CompletableMergeSubscriber.this.getOrCreateErrors().offer(e);
                    CompletableMergeSubscriber.this.terminate();
                    if (CompletableMergeSubscriber.this.delayErrors && !CompletableMergeSubscriber.this.done) {
                        CompletableMergeSubscriber.this.request(1L);
                    }
                }

                @Override
                public void onCompleted() {
                    if (this.innerDone) {
                        return;
                    }
                    this.innerDone = true;
                    CompletableMergeSubscriber.this.set.remove(this.d);
                    CompletableMergeSubscriber.this.terminate();
                    if (!CompletableMergeSubscriber.this.done) {
                        CompletableMergeSubscriber.this.request(1L);
                    }
                }
            });
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaHooks.onError(t);
                return;
            }
            this.getOrCreateErrors().offer(t);
            this.done = true;
            this.terminate();
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.terminate();
        }

        void terminate() {
            Queue<Throwable> q;
            if (this.wip.decrementAndGet() == 0) {
                Queue<Throwable> q2 = this.errors.get();
                if (q2 == null || q2.isEmpty()) {
                    this.actual.onCompleted();
                } else {
                    Throwable e = CompletableOnSubscribeMerge.collectErrors(q2);
                    if (this.once.compareAndSet(false, true)) {
                        this.actual.onError(e);
                    } else {
                        RxJavaHooks.onError(e);
                    }
                }
            } else if (!this.delayErrors && (q = this.errors.get()) != null && !q.isEmpty()) {
                Throwable e = CompletableOnSubscribeMerge.collectErrors(q);
                if (this.once.compareAndSet(false, true)) {
                    this.actual.onError(e);
                } else {
                    RxJavaHooks.onError(e);
                }
            }
        }
    }
}

