/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.internal;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.internal.EndpointHealth;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class ServicesHealth {
    private static final ObjectMapper JACKSON = new ObjectMapper();
    private static final int VERSION = 0;
    private final int version;
    private final List<EndpointHealth> endpoints;

    public ServicesHealth(List<EndpointHealth> endpoints) {
        this.endpoints = endpoints;
        this.version = 0;
    }

    public List<EndpointHealth> endpoints() {
        return this.endpoints;
    }

    public List<EndpointHealth> endpoints(ServiceType type) {
        ArrayList<EndpointHealth> filtered = new ArrayList<EndpointHealth>(this.endpoints.size());
        for (EndpointHealth h : this.endpoints) {
            if (!h.type().equals((Object)type)) continue;
            filtered.add(h);
        }
        return filtered;
    }

    public String toJson() {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        HashMap services = new HashMap();
        for (EndpointHealth h : this.endpoints) {
            String type = ServicesHealth.serviceTypeFromEnum(h.type());
            if (!services.containsKey(type)) {
                services.put(type, new ArrayList());
            }
            List eps = (List)services.get(type);
            eps.add(h.toMap());
        }
        result.put("version", Integer.valueOf(this.version));
        result.put("services", services);
        try {
            return JACKSON.writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not encode as JSON string.", e);
        }
    }

    private static String serviceTypeFromEnum(ServiceType type) {
        switch (type) {
            case VIEW: {
                return "view";
            }
            case BINARY: {
                return "kv";
            }
            case QUERY: {
                return "n1ql";
            }
            case CONFIG: {
                return "config";
            }
            case SEARCH: {
                return "fts";
            }
            case ANALYTICS: {
                return "analytics";
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "ServicesHealth{version=" + this.version + ", endpoints=" + this.endpoints + '}';
    }
}

