/**
 * 
 */
package org.gcube.accounting.persistence.couchdb;

import java.io.Serializable;
import java.util.Map;

import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.persistence.AccountingPersistenceBackend;
import org.gcube.accounting.persistence.AccountingPersistenceConfiguration;
import org.gcube.common.couchdb.connector.HttpCouchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class AccountingPersistenceCouchDB extends AccountingPersistenceBackend {
	
	private static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceCouchDB.class);

	protected HttpCouchClient httpCouchClient;
	
	protected static final String DB_NAME = "dbName"; 
	
	public AccountingPersistenceCouchDB() throws Exception {
		super();
	}
	
	@Override
	public void close() throws Exception {}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void prepareConnection(AccountingPersistenceConfiguration configuration) throws Exception {
		logger.debug("Preparing Connection for {}", this.getClass().getSimpleName());
		
		httpCouchClient = new HttpCouchClient(
				configuration.getUri().toURL().toString(), 
				configuration.getProperty(DB_NAME),
				configuration.getUsername(),
				configuration.getPassword());
	}
	
	protected void createItem(JsonNode node, String id) throws Exception {
		httpCouchClient.put(node.toString(), id);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void reallyAccount(UsageRecord usageRecord) throws Exception {
		JsonNode node = usageRecordToJsonNode(usageRecord);
		createItem(node, usageRecord.getId());
	}
	
	public static JsonNode usageRecordToJsonNode(UsageRecord usageRecord) throws Exception {
		ObjectMapper mapper = new ObjectMapper();
		JsonNode node = mapper.valueToTree(usageRecord.getResourceProperties());
		return node;
	}
	
	public static UsageRecord jsonNodeToUsageRecord(JsonNode jsonNode) throws Exception {
		ObjectMapper mapper = new ObjectMapper();
		@SuppressWarnings("unchecked")
		Map<String, Serializable> result = mapper.convertValue(jsonNode, Map.class);
		UsageRecord usageRecord = BasicUsageRecord.getUsageRecord(result);
		return usageRecord;
	}
	
}
