/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.threads.QueryConstructurThread;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Filter;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.CustomQueryDescriptorFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.CustomQueryDescriptorStubs;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FilterType;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomQueryManager {
    public static final String userQueryTable = "userqueries";
    static final Logger logger = LoggerFactory.getLogger(CustomQueryManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setUserCustomQuery(String user, String queryString) throws Exception {
        try (DBSession session = null;){
            CustomQueryManager.deleteUserQuery(user);
            session = DBSession.getInternalDBSession();
            String tableName = ServiceUtils.generateId("CUSTOM", "").toLowerCase();
            logger.trace("Inserting reference on table..");
            CustomQueryDescriptorStubs toInsert = new CustomQueryDescriptorStubs();
            toInsert.actualTableName(tableName);
            toInsert.creationTime(Long.valueOf(System.currentTimeMillis()));
            toInsert.query(queryString);
            toInsert.user(user);
            toInsert.lastAccess(Long.valueOf(System.currentTimeMillis()));
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(toInsert.toRow());
            session.insertOperation(userQueryTable, rows);
            QueryConstructurThread t = new QueryConstructurThread(user, QueryConstructurThread.Operation.CREATE, queryString, tableName);
            t.start();
            String string = user;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPagedResult(String user, PagedRequestSettings settings) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            CustomQueryManager.updateLastAccessTime(user);
            CustomQueryDescriptorStubs desc = CustomQueryManager.getDescriptor(user);
            String query = "SELECT * from " + desc.actualTableName() + " ORDER BY " + settings.getOrderField() + " " + settings.getOrderDirection() + " LIMIT " + settings.getLimit() + " OFFSET " + settings.getOffset();
            String string = DBUtils.toJSon(session.executeQuery(query), desc.rows());
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deleteUserQuery(String user) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            CustomQueryDescriptorStubs desc = CustomQueryManager.getDescriptor(user);
            QueryConstructurThread t = new QueryConstructurThread(user, QueryConstructurThread.Operation.DELETE, desc.query(), desc.actualTableName());
            t.start();
            logger.trace("Deleting " + user + "'s custom query reference");
            ArrayList<Field> field = new ArrayList<Field>();
            field.add(desc.getField(CustomQueryDescriptorFields.userid));
            int n = session.deleteOperation(userQueryTable, field);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLastAccessTime(String userId) throws Exception {
        try (DBSession session = null;){
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            keys.add(new ArrayList<Field>(Arrays.asList(new Field(CustomQueryDescriptorFields.userid + "", userId, FieldType.STRING))));
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(new ArrayList<Field>(Arrays.asList(new Field(CustomQueryDescriptorFields.lastaccess + "", System.currentTimeMillis() + "", FieldType.LONG))));
            session = DBSession.getInternalDBSession();
            if (session.updateOperation(userQueryTable, keys, rows) == 0) {
                throw new Exception("No custom query reference found for user " + userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clean() throws Exception {
        try (DBSession session = null;){
            int keepAliveMinutes = ServiceContext.getContext().getPropertyAsInteger("CUSTOM_QUERY_KEEP_ALIVE_MINUTES");
            Filter timeFilter = new Filter(FilterType.smaller_then, new Field(CustomQueryDescriptorFields.lastaccess + "", System.currentTimeMillis() - (long)(keepAliveMinutes * 1000 * 60) + "", FieldType.LONG));
            String queryString = "SELECT * FROM userqueries WHERE " + CustomQueryDescriptorFields.lastaccess + " " + timeFilter.toSQLString();
            session = DBSession.getInternalDBSession();
            ResultSet rs = session.executeQuery(queryString);
            int count = 0;
            while (rs.next()) {
                String user = rs.getString(CustomQueryDescriptorFields.userid + "");
                try {
                    count += CustomQueryManager.deleteUserQuery(user);
                }
                catch (Exception e) {
                    logger.warn("Unable to delete custom query for user " + user, (Throwable)e);
                }
            }
            int n = count;
            return n;
        }
    }

    public static CustomQueryDescriptorStubs getDescriptor(String userid) throws Exception {
        try (DBSession session = null;){
            CustomQueryManager.updateLastAccessTime(userid);
            session = DBSession.getInternalDBSession();
            ArrayList<Field> field = new ArrayList<Field>();
            field.add(new Field(CustomQueryDescriptorFields.userid + "", userid, FieldType.STRING));
            ResultSet rs = session.executeFilteredQuery(field, userQueryTable, CustomQueryDescriptorFields.userid + "", OrderDirection.ASC);
            if (rs.next()) {
                CustomQueryDescriptorStubs customQueryDescriptorStubs = new CustomQueryDescriptorStubs(rs);
                return customQueryDescriptorStubs;
            }
            throw new Exception("Custom Query Not Found for user " + userid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int updateDescriptor(CustomQueryDescriptorStubs desc) throws Exception {
        try (DBSession session = null;){
            desc.lastAccess(Long.valueOf(System.currentTimeMillis()));
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(desc.getField(CustomQueryDescriptorFields.userid));
            keys.add(key);
            ArrayList<Field> row = new ArrayList<Field>();
            for (CustomQueryDescriptorFields f : CustomQueryDescriptorFields.values()) {
                if (f.equals((Object)CustomQueryDescriptorFields.userid)) continue;
                row.add(desc.getField(f));
            }
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(row);
            int n = session.updateOperation(userQueryTable, keys, rows);
            return n;
        }
    }
}

