/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions;

import java.util.HashMap;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.BatchGenerator;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.EnvironmentalExecutionReportItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchGeneratorObjectFactory
extends BasePoolableObjectFactory {
    static final Logger logger = LoggerFactory.getLogger(BatchGeneratorObjectFactory.class);
    private static HashMap<Integer, BatchGenerator> generatorMap = new HashMap();
    private final BatchPoolType type;

    public static EnvironmentalExecutionReportItem getReport(int batchId, boolean getResourceInfo) throws Exception {
        BatchGenerator batch = generatorMap.get(batchId);
        if (batch == null) {
            logger.debug("Requested Batch id (" + batchId + ") Not Found, available ids  : " + generatorMap.keySet());
            return null;
        }
        return batch.getReport(getResourceInfo);
    }

    public BatchGeneratorObjectFactory(BatchPoolType type) {
        this.type = type;
    }

    public Object makeObject() throws Exception {
        BatchGenerator batch = new BatchGenerator(this.type);
        generatorMap.put(batch.getReportId(), batch);
        return batch;
    }

    public void activateObject(Object obj) throws Exception {
        super.activateObject(obj);
    }

    public void destroyObject(Object obj) throws Exception {
        super.destroyObject(obj);
    }

    public void passivateObject(Object obj) throws Exception {
        super.passivateObject(obj);
    }

    public static enum BatchPoolType {
        LOCAL,
        REMOTE;

    }
}

