/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.publishing.gis;

import java.awt.Color;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.AquaMapsManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.ConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleGenerationRequest {
    static final Logger logger = LoggerFactory.getLogger(StyleGenerationRequest.class);
    private String nameStyle;
    private String attributeName;
    private int nClasses;
    private Color c1;
    private Color c2;
    private Class typeValue;
    private String max;
    private String min;
    private ClusterScaleType clusterScaleType;

    public static String getDefaultDistributionStyle() throws Exception {
        return ConfigurationManager.getVODescriptor().getGeoServers().get(0).getDefaultDistributionStyle();
    }

    public static StyleGenerationRequest getBiodiversityStyle(int min, int max, ClusterScaleType type, String mapName) {
        StyleGenerationRequest toReturn = new StyleGenerationRequest();
        toReturn.setAttributeName(AquaMapsManager.maxSpeciesCountInACell);
        toReturn.setNameStyle(ServiceUtils.generateId(mapName, (Object)((Object)type) + "Style"));
        toReturn.setC1(Color.YELLOW);
        toReturn.setC2(Color.RED);
        toReturn.setClusterScaleType(type);
        toReturn.setMax(String.valueOf(max));
        toReturn.setMin(String.valueOf(min));
        int Nclasses = max - min > 4 ? 5 : max - min;
        logger.debug("Found " + Nclasses + " classes for style (min : " + min + ", max : " + max + ")");
        toReturn.setNClasses(Nclasses);
        toReturn.setTypeValue(Integer.class);
        return toReturn;
    }

    public String getNameStyle() {
        return this.nameStyle;
    }

    public void setNameStyle(String nameStyle) {
        this.nameStyle = nameStyle;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public int getNClasses() {
        return this.nClasses;
    }

    public void setNClasses(int classes) {
        this.nClasses = classes;
    }

    public Color getC1() {
        return this.c1;
    }

    public void setC1(Color c1) {
        this.c1 = c1;
    }

    public Color getC2() {
        return this.c2;
    }

    public void setC2(Color c2) {
        this.c2 = c2;
    }

    public Class getTypeValue() {
        return this.typeValue;
    }

    public void setTypeValue(Class typeValue) {
        this.typeValue = typeValue;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public void setClusterScaleType(ClusterScaleType clusterScaleType) {
        this.clusterScaleType = clusterScaleType;
    }

    public ClusterScaleType getClusterScaleType() {
        return this.clusterScaleType;
    }

    public static enum ClusterScaleType {
        linear,
        logarithmic;

    }
}

