/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig;

import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.DBDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.DataSourceDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.GeoServerDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.ParameterNotFoundException;

public class VODescriptor {
    private String scope;
    private List<GeoServerDescriptor> geoServers = new ArrayList<GeoServerDescriptor>();
    private DataSourceDescriptor geoNetwork;
    private DBDescriptor internalDB;
    private DBDescriptor geoDb;
    private DBDescriptor publisherDB;

    public VODescriptor(String scope, List<GeoServerDescriptor> geoServers, DataSourceDescriptor geoNetwork, DBDescriptor internalDB, DBDescriptor geoDb, DBDescriptor publisherDB) {
        this.scope = scope;
        this.geoServers = geoServers;
        this.geoNetwork = geoNetwork;
        this.internalDB = internalDB;
        this.geoDb = geoDb;
        this.publisherDB = publisherDB;
    }

    public String getScope() {
        return this.scope;
    }

    public List<GeoServerDescriptor> getGeoServers() {
        return this.geoServers;
    }

    public DataSourceDescriptor getGeoNetwork() {
        return this.geoNetwork;
    }

    public DBDescriptor getInternalDB() {
        return this.internalDB;
    }

    public DBDescriptor getGeoDb() {
        return this.geoDb;
    }

    public DBDescriptor getPublisherDB() {
        return this.publisherDB;
    }

    public GeoServerDescriptor getGeoServerByEntryPoint(String entryPoint) throws ParameterNotFoundException {
        for (GeoServerDescriptor desc : this.geoServers) {
            if (!desc.getEntryPoint().equals(entryPoint)) continue;
            return desc;
        }
        throw new ParameterNotFoundException();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VODescriptor [scope=");
        builder.append(this.scope);
        builder.append(", geoServers=");
        builder.append(this.geoServers);
        builder.append(", geoNetwork=");
        builder.append(this.geoNetwork);
        builder.append(", internalDB=");
        builder.append(this.internalDB);
        builder.append(", geoDb=");
        builder.append(this.geoDb);
        builder.append(", publisherDB=");
        builder.append(this.publisherDB);
        builder.append("]");
        return builder.toString();
    }
}

