/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.images;

import com.j256.ormlite.dao.Dao;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Maps;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Publisher;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.BulkItem;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.ItemResources;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;
import org.gcube.application.aquamaps.images.Common;
import org.gcube.application.aquamaps.images.SpeciesCSVLineProcessor;
import org.gcube.application.aquamaps.images.model.MapItem;
import org.gcube.application.aquamaps.images.model.SpeciesInfo;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpeciesInfoImportThread
extends Thread {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private static SpeciesInfoImportThread instance;
    private static final Logger logger;
    private Properties props;

    public static synchronized SpeciesInfoImportThread start(Properties prop) {
        if (instance == null) {
            instance = new SpeciesInfoImportThread(prop);
        }
        return instance;
    }

    private SpeciesInfoImportThread(Properties props) {
        this.props = props;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Hashtable configuration = (Hashtable)this.props.clone();
            ArrayList<File> toDelete = new ArrayList<File>();
            try {
                logger.debug("Using configuration : " + configuration);
                String scope = (String)configuration.get("SCOPE");
                ScopeProvider.instance.set(scope);
                logger.trace("Fetching info in scope " + scope);
                Maps maps = (Maps)AbstractPlugin.maps().build();
                Publisher pub = (Publisher)AbstractPlugin.publisher().build();
                DataManagement dmService = (DataManagement)AbstractPlugin.dataManagement().build();
                int hspenID = 0;
                for (Field f : dmService.getDefaultSources()) {
                    if (!f.name().equals(ResourceType.HSPEN + "")) continue;
                    hspenID = f.getValueAsInteger();
                    logger.debug("Using hspen id " + hspenID);
                    break;
                }
                File toRead = maps.getCSVSpecies(hspenID, null, null);
                toDelete.add(toRead);
                CSVReaderProcessor processor = new CSVReaderProcessor();
                processor.setDelimiter(',');
                processor.setHasHeader(true);
                SpeciesCSVLineProcessor lineProcessor = new SpeciesCSVLineProcessor();
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(toRead), Charset.defaultCharset());
                processor.processStream((Reader)reader, (CSVLineProcessor)lineProcessor);
                long lastUpdate = Common.get().getLastCompletedUpdate();
                long performedUpdateTime = System.currentTimeMillis();
                logger.trace("Fetched " + lineProcessor.getCount() + " species, getting maps generated after " + format.format(new Date(lastUpdate)));
                File bulkMaps = pub.getBulkUpdates(true, false, null, lastUpdate);
                toDelete.add(bulkMaps);
                AquaMapsXStream stream = AquaMapsXStream.getXMLInstance();
                ObjectInputStream ois = stream.createObjectInputStream((InputStream)new FileInputStream(bulkMaps));
                Dao speciesDao = Common.get().getSpeciesDao();
                Dao mapDao = Common.get().getMapDao();
                long bulkCount = 0L;
                long updateCount = 0L;
                long insertCount = 0L;
                try {
                    try {
                        while (true) {
                            try {
                                block24: while (true) {
                                    BulkItem item = (BulkItem)ois.readObject();
                                    ++bulkCount;
                                    String scientificName = ((SpeciesInfo)speciesDao.queryForId((Object)item.getSpeciesId())).getScientificName();
                                    Iterator i$ = item.getResources().entrySet().iterator();
                                    while (true) {
                                        if (!i$.hasNext()) continue block24;
                                        Map.Entry entry = i$.next();
                                        ItemResources res = (ItemResources)entry.getValue();
                                        MapItem mapItem = new MapItem(((Integer)entry.getKey()).intValue(), item.getSpeciesId(), scientificName, res.getStandardImgUri(), res.getStandardLayerId());
                                        boolean inserted = Common.get().insertOrUpdateMapInfoByCoverage(mapItem);
                                        if (inserted) {
                                            ++insertCount;
                                            continue;
                                        }
                                        ++updateCount;
                                    }
                                    break;
                                }
                            }
                            catch (EOFException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                logger.warn("Unable to load map info", (Throwable)e);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (EOFException e) {
                        IOUtils.closeQuietly((InputStream)ois);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)ois);
                    throw throwable;
                }
                logger.debug("Parsed " + bulkCount + " bulkItems, inserted " + insertCount + " map entries, updated " + updateCount);
                logger.debug("Current map count : " + mapDao.countOf());
                Common.get().setLastConfiguration((Map)configuration);
                Common.get().setLastCompletedUpdate(Long.valueOf(performedUpdateTime));
                continue;
            }
            catch (Throwable e) {
                logger.error("Unexpected Error ", e);
                continue;
            }
            finally {
                for (File f : toDelete) {
                    FileUtils.deleteQuietly((File)f);
                }
                try {
                    long minutes = Long.parseLong((String)configuration.get("FETCH_ROUTINE_INTERVAL_MINUTES"));
                    logger.trace("Going to execute again in " + minutes + " min");
                    SpeciesInfoImportThread.sleep((long)(minutes * 60L * 1000L));
                }
                catch (InterruptedException e) {
                }
                catch (Throwable t) {
                    logger.error("Unexpected exception ", t);
                }
                continue;
            }
            break;
        }
    }

    static {
        logger = LoggerFactory.getLogger(SpeciesInfoImportThread.class);
    }
}

