/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.login;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.application.framework.core.security.LDAPAuthenticationModule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import sun.misc.BASE64Decoder;

public class Login
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String auth = request.getHeader("Authorization");
        HttpSession session = request.getSession(true);
        if (session.getAttribute("logon.isDone") == null) {
            String username = this.allowUserGet(auth);
            if (username == null) {
                response.setHeader("WWW-Authenticate", "BASIC realm=\"D4ScienceUsers\"");
                response.sendError(401);
                return;
            }
            System.out.println("The session id is: " + session.getId());
            session.setAttribute("logon.isDone", (Object)username);
            String target = (String)session.getAttribute("target");
            try {
                response.setStatus(200);
                response.sendRedirect(response.encodeRedirectURL(request.getRequestURI()));
                return;
            }
            catch (Exception ignored) {
                System.out.println("Redirect failed");
                System.out.println(target);
            }
        } else {
            System.out.println("No authentication needed");
            return;
        }
    }

    protected String allowUserGet(String auth) throws IOException {
        if (auth == null) {
            return null;
        }
        if (!auth.toUpperCase().startsWith("BASIC ")) {
            return null;
        }
        BASE64Decoder dec = new BASE64Decoder();
        String userpassEncoded = auth.substring(6);
        String userpassDecoded = new String(dec.decodeBuffer(userpassEncoded));
        String[] token = userpassDecoded.split(":");
        if (token.length < 2) {
            return null;
        }
        String user1 = token[0];
        userpassDecoded = token[1];
        boolean authenticated = false;
        LDAPAuthenticationModule authModule = new LDAPAuthenticationModule();
        try {
            authenticated = authModule.checkAuthentication(user1, userpassDecoded);
        }
        catch (Throwable all) {
            all.printStackTrace();
        }
        if (authenticated) {
            System.out.println("The user exists");
            return user1;
        }
        System.out.println("The user doesn't exist!");
        return null;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StringWriter writer;
        String xmlToStr;
        PrintWriter out;
        HttpSession session;
        String auth = request.getParameter("password");
        String username = request.getParameter("username");
        if (username == null || auth == null) {
            response.sendError(404);
        }
        if ((session = request.getSession(true)).getAttribute("logon.isDone") == null) {
            if (!this.allowUserPost(auth, username)) {
                response.sendError(401);
                return;
            }
            System.out.println("The session id is: " + session.getId());
            session.setAttribute("logon.isDone", (Object)username);
            out = response.getWriter();
            response.setContentType("text/xml");
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = dbfac.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("SessionID");
            doc.appendChild(root);
            Element sessionEl = doc.createElement("jsessionid");
            sessionEl.setTextContent(session.getId());
            root.appendChild(sessionEl);
            xmlToStr = "";
            writer = new StringWriter();
            try {
                DOMSource domSource = new DOMSource(doc);
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No authentication needed");
            return;
        }
        xmlToStr = writer.toString();
        System.out.println(xmlToStr);
        out.write(xmlToStr);
        out.close();
    }

    protected boolean allowUserPost(String auth, String user) throws IOException {
        System.out.println("username is: " + user);
        if (auth == null) {
            return false;
        }
        String user1 = user;
        String userpassDecoded = auth;
        boolean authenticated = false;
        LDAPAuthenticationModule authModule = new LDAPAuthenticationModule();
        try {
            authenticated = authModule.checkAuthentication(user1, userpassDecoded);
        }
        catch (Throwable all) {
            all.printStackTrace();
        }
        if (authenticated) {
            System.out.println("The user exists");
            return true;
        }
        System.out.println("The user doesn't exist!");
        return false;
    }
}

