/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface;

import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.encoder.GSResourceEncoder;
import java.io.File;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.geoserverinterface.Constants;
import org.gcube.common.geoserverinterface.GeoCallerConfigurationInterface;
import org.gcube.common.geoserverinterface.GeonetworkCaller;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface;
import org.gcube.common.geoserverinterface.GeoserverCaller;
import org.gcube.common.geoserverinterface.HttpResourceControl;
import org.gcube.common.geoserverinterface.bean.BoundsRest;
import org.gcube.common.geoserverinterface.bean.CoverageStoreRest;
import org.gcube.common.geoserverinterface.bean.CoverageTypeRest;
import org.gcube.common.geoserverinterface.bean.CswLayersResult;
import org.gcube.common.geoserverinterface.bean.CswRecord;
import org.gcube.common.geoserverinterface.bean.DataStoreRest;
import org.gcube.common.geoserverinterface.bean.FeatureTypeRest;
import org.gcube.common.geoserverinterface.bean.GroupRest;
import org.gcube.common.geoserverinterface.bean.LayerRest;
import org.gcube.common.geoserverinterface.bean.MetadataInfo;
import org.gcube.common.geoserverinterface.bean.WorkspaceRest;
import org.opengis.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoCaller
extends GeoCallerConfigurationInterface {
    private static final Logger logger = LoggerFactory.getLogger(GeoCaller.class);
    private static final String GEOTIFF_TYPE = "GeoTIFF";
    private GeoserverCaller geoserverCaller = null;
    private GeonetworkCaller geonetworkCaller = null;
    private ArrayList<String> wmsGeoserverList = null;
    private ArrayList<String> wfsGeoserverList = null;
    private boolean isAvailableGeonetwork = false;
    private final String GEONETWORKERROR = "Geonetwork is not instantiated";
    private final String INSTANCEERROR = "Geonetwork is not available";
    private HttpResourceControl httpRC = new HttpResourceControl();
    private String geonetworkUrl;
    private String geonetworkUser;
    private String geoserverWmsUrl;
    private String geoserverUser;
    private String geoserverPwd;
    private GeonetworkCommonResourceInterface.GeoserverMethodResearch geoserverResearchMethod;
    private String geonetworkPwd;
    private String currentWmsGeoserver;

    public GeoCaller(String geonetworkUrl, String geonetworkUser, String geonetworkPwd, String geoserverWmsUrl, String geoserverUser, String geoserverPwd, GeonetworkCommonResourceInterface.GeoserverMethodResearch geoserverResearchMethod) throws Exception {
        this.geonetworkUrl = geonetworkUrl;
        this.geonetworkUser = geonetworkUser;
        this.geonetworkPwd = geonetworkPwd;
        this.geoserverWmsUrl = geoserverWmsUrl;
        this.geoserverUser = geoserverUser;
        this.geoserverPwd = geoserverPwd;
        this.geoserverResearchMethod = geoserverResearchMethod;
        if (geonetworkUrl != null && this.httpRC.isAvailableNetworkResource(geonetworkUrl, TRYSLEEPTIME, MAXTRY, null, null)) {
            this.isAvailableGeonetwork = true;
            this.geonetworkCaller = new GeonetworkCaller(this.geonetworkUrl, this.geonetworkUser, this.geonetworkPwd, this.geoserverUser, this.geoserverPwd);
            this.wmsGeoserverList = new ArrayList();
            this.wfsGeoserverList = new ArrayList();
            this.instanceGeoserverCaller(geoserverResearchMethod, geoserverUser, geoserverPwd);
        } else if (geoserverWmsUrl != null) {
            this.setWmsGeoserver(geoserverWmsUrl, geoserverUser, geoserverPwd);
        } else {
            throw new Exception("Geonetwork is not available");
        }
    }

    public GeoCaller(String geoserverWmsUrl, String geoserverUsername, String geoserverPassword) throws Exception {
        this.setWmsGeoserver(geoserverWmsUrl, geoserverUsername, geoserverPassword);
    }

    private void instanceGeoserverCaller(GeonetworkCommonResourceInterface.GeoserverMethodResearch geoserverResearchMethod, String geoserverUsername, String geoserverPassword) {
        this.loadGeoserverListsFromGeonetwork(geoserverResearchMethod);
        try {
            this.currentWmsGeoserver = this.wmsGeoserverList.get(0);
            this.geoserverCaller = new GeoserverCaller(this.currentWmsGeoserver, geoserverUsername, geoserverPassword);
        }
        catch (Exception e) {
            try {
                this.setWmsGeoserver(this.geoserverWmsUrl, geoserverUsername, geoserverPassword);
            }
            catch (Exception e1) {
                throw new RuntimeException(e);
            }
        }
    }

    private void loadGeoserverListsFromGeonetwork(GeonetworkCommonResourceInterface.GeoserverMethodResearch geoserverResearchMethod) {
        if (geoserverResearchMethod != null) {
            this.wmsGeoserverList = this.geonetworkCaller.getOrderedListOfGeoserver(geoserverResearchMethod, GeonetworkCommonResourceInterface.GeoserverType.WMS);
            this.wfsGeoserverList = this.geonetworkCaller.getOrderedListOfGeoserver(geoserverResearchMethod, GeonetworkCommonResourceInterface.GeoserverType.WFS);
        } else {
            this.wmsGeoserverList = this.geonetworkCaller.getOrderedListOfGeoserver(DEFAULTMETHODRESEARCH, GeonetworkCommonResourceInterface.GeoserverType.WMS);
            this.wfsGeoserverList = this.geonetworkCaller.getOrderedListOfGeoserver(DEFAULTMETHODRESEARCH, GeonetworkCommonResourceInterface.GeoserverType.WFS);
        }
    }

    public void setWmsGeoserver(String geoserverUrl, String geoserverUsername, String geoserverPassword) throws Exception {
        if (!this.httpRC.isAvailableNetworkResource(geoserverUrl, TRYSLEEPTIME, MAXTRY, null, null)) {
            throw new Exception("Geoserver " + geoserverUrl + " not found");
        }
        this.wmsGeoserverList = new ArrayList();
        this.wmsGeoserverList.add(geoserverUrl);
        this.geoserverCaller = new GeoserverCaller(geoserverUrl, geoserverUsername, geoserverPassword);
        this.currentWmsGeoserver = geoserverUrl;
    }

    public void setWfsGeoserver(String geoserverUrl, String geoserverUsername, String geoserverPassword) throws Exception {
        if (!this.httpRC.isAvailableNetworkResource(geoserverUrl, TRYSLEEPTIME, MAXTRY, null, null)) {
            throw new Exception("Geoserver " + geoserverUrl + " not found");
        }
        this.wfsGeoserverList = new ArrayList();
        this.wfsGeoserverList.add(geoserverUrl);
        this.geoserverCaller = new GeoserverCaller(geoserverUrl, geoserverUsername, geoserverPassword);
    }

    public String getCurrentWmsGeoserver() {
        return this.currentWmsGeoserver;
    }

    public String getCurrentWfsGeoserver() {
        return this.wfsGeoserverList.get(0);
    }

    public ArrayList<String> getWmsGeoserverList() {
        return this.wmsGeoserverList;
    }

    public ArrayList<String> getWfsGeoserverList() {
        return this.wfsGeoserverList;
    }

    public void setWmsGeoserverResearchStrategy(GeonetworkCommonResourceInterface.GeoserverMethodResearch strategy, String user, String pwd) throws Exception {
        if (!this.isAvailableGeonetwork) {
            throw new Exception("Geonetwork is not instantiated");
        }
        this.wmsGeoserverList = new ArrayList();
        this.wmsGeoserverList = this.geonetworkCaller.getOrderedListOfGeoserver(strategy, GeonetworkCommonResourceInterface.GeoserverType.WMS);
        this.geoserverCaller = new GeoserverCaller(this.wmsGeoserverList.get(0), user, pwd);
    }

    public void setWfsGeoserverResearchStrategy(GeonetworkCommonResourceInterface.GeoserverMethodResearch strategy, String user, String pwd) throws Exception {
        if (!this.isAvailableGeonetwork) {
            throw new Exception("Geonetwork is not instantiated");
        }
        this.wfsGeoserverList = new ArrayList();
        this.wfsGeoserverList = this.geonetworkCaller.getOrderedListOfGeoserver(strategy, GeonetworkCommonResourceInterface.GeoserverType.WFS);
        this.geoserverCaller = new GeoserverCaller(this.wfsGeoserverList.get(0), user, pwd);
    }

    public String getHarvestings() throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkGetMethods().getListHarvestings();
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public String getMetadataByFileIdentifier(String uuid) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkGetMethods().getMetadataByFileIdentifier(uuid);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public String getMetadataById(String id) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkGetMethods().getMetadataById(id);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public String searchLayerByTitleIsLike(String title) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkGetMethods().searchLayerByTitleIsLike(title);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public String searchLayerByTitleIsEqualTo(String title) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkGetMethods().searchLayerByTitleIsEqualTo(title);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public String getHarvestingById(String id) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkGetMethods().getHarvestingById(id);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public String getGeonetworkLayerInfoBySearchService(String title, GeonetworkCommonResourceInterface.GeonetworkCategory category, Boolean similarity) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkGetMethods().searchService(title, category, similarity);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public ArrayList<CswRecord> getGeonetworkCswRecordsBySearch(String anyText, int maxRecords) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkGetMethods().getCswRecordsBySearch(anyText, maxRecords);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public String insertMetadata(String fileIdentifier, String workspace, String layerTitle, String layerName, String description, GeonetworkCommonResourceInterface.GeonetworkCategory category, String geoServerWmsUrl) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkPutMethods().insertMetadata(fileIdentifier, workspace, layerTitle, layerName, description, category, geoServerWmsUrl);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public String insertMetadata(MetadataInfo metadataInfo) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkPutMethods().insertMetadata(metadataInfo);
        }
        throw new Exception("You must be logged");
    }

    public String insertMetadataByCswTransaction(String fileIdentifier, String workspace, String layerTitle, String layerName, String description, String geoServerWmsUrl) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkPutMethods().insertMetadataByCswTransaction(fileIdentifier, workspace, layerTitle, layerName, description, geoServerWmsUrl);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public String updateHarvesting(String id) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkPutMethods().updateHarvesting(id);
        }
        throw new Exception("You must be logged");
    }

    public String deleteMetadataById(String id) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkPutMethods().deleteMetadataById(id);
        }
        throw new Exception("You must be logged");
    }

    public ArrayList<String> listWorkspaces() throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().listWorkspaces();
    }

    public WorkspaceRest getWorkspace(String wokspaceName) throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().getWorkspace(wokspaceName);
    }

    public List<String> listDataStores(String wokspaceName) throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().listDataStores(wokspaceName);
    }

    public DataStoreRest getDataStore(String wokspaceName, String dataStore) throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().getDataStore(wokspaceName, dataStore);
    }

    public ArrayList<String> listFeaturetypes(String wokspaceName, String dataStore) throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().listFeaturetypes(wokspaceName, dataStore);
    }

    public FeatureTypeRest getFeatureType(String wokspaceName, String dataStore, String featureType) throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().getFeatureType(wokspaceName, dataStore, featureType);
    }

    public CoverageTypeRest getCoverageType(String wokspaceName, String coveragestore, String coverageType) throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().getCoverageType(wokspaceName, coveragestore, coverageType);
    }

    public ArrayList<String> listLayers() throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().listLayers();
    }

    public LayerRest getLayer(String nameLayer) throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().getLayer(nameLayer);
    }

    public ArrayList<String> listLayerGroups() throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().listLayerGroups();
    }

    public GroupRest getLayerGroup(String nameGroup) throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().getLayerGroup(nameGroup);
    }

    public ArrayList<String> listStyles() throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().listStyles();
    }

    public ArrayList<String> listStyles(String layerName) throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().listStyles(layerName);
    }

    public InputStream getStyle(String styleName) throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().getStyle(styleName);
    }

    public List<String> listCoverageStores(String wokspaceName) throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().listCoverageStores(wokspaceName);
    }

    public CoverageStoreRest getCoverageStore(String wokspaceName, String coverageStore) throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().getCoverageStore(wokspaceName, coverageStore);
    }

    public ArrayList<String> listCoverages(String wokspaceName, String coverageStore) throws Exception {
        return this.geoserverCaller.getGeoserverGetMethods().listCoverages(wokspaceName, coverageStore);
    }

    public boolean addLayersGroup(GroupRest group, GeonetworkCommonResourceInterface.GeonetworkCategory category) throws Exception {
        boolean insertGeoserverStatus = this.geoserverCaller.getGeoserverPutMethods().addLayersGroup(group);
        if (insertGeoserverStatus && this.isAvailableGeonetwork && this.geonetworkCaller.getGeonetworkPutMethods().insertMetadataByGroupRest(group, category, this.getCurrentWmsGeoserver()) != null) {
            return true;
        }
        return insertGeoserverStatus;
    }

    public boolean addPreExistentGeoTiff(String fileName, String layerName, String layerTitle, String workspace, GeonetworkCommonResourceInterface.GeonetworkCategory category, String description, String abstr) throws Exception {
        File geotiff;
        boolean insertGeoserverStatus = true;
        GeoServerRESTPublisher publisher = new GeoServerRESTPublisher(this.currentWmsGeoserver, this.geoserverUser, this.geoserverPwd);
        String storeName = "store_" + layerName;
        insertGeoserverStatus = publisher.publishExternalGeoTIFF(workspace, storeName, geotiff = new File(Constants.getGeoserverDataAbsolutePath() + workspace + "/" + fileName), layerName, "EPSG:4326", GSResourceEncoder.ProjectionPolicy.REPROJECT_TO_DECLARED, "raster");
        if (insertGeoserverStatus && this.isAvailableGeonetwork) {
            FeatureTypeRest featureTypeRest = new FeatureTypeRest();
            featureTypeRest.setName(layerName);
            featureTypeRest.setTitle(layerTitle);
            featureTypeRest.setWorkspace(workspace);
            featureTypeRest.setLatLonBoundingBox(new BoundsRest(-180.0, 180.0, -85.5, 90.0, "EPSG:4326"));
            featureTypeRest.setNativeBoundingBox(new BoundsRest(-180.0, 180.0, -85.5, 90.0, "EPSG:4326"));
            boolean insertGeonetworkSataus = this.geonetworkCaller.getGeonetworkPutMethods().insertMetadataByFeatureType(featureTypeRest, category, this.getCurrentWmsGeoserver(), description, abstr) != null;
            return insertGeonetworkSataus;
        }
        return insertGeoserverStatus;
    }

    public boolean addFeatureType(FeatureTypeRest featureTypeRest, GeonetworkCommonResourceInterface.GeonetworkCategory category, String description, String abstr) throws Exception {
        boolean insertGeoserverStatus = true;
        if (!this.layerExists(featureTypeRest.getName())) {
            insertGeoserverStatus = this.geoserverCaller.getGeoserverPutMethods().addFeatureType(featureTypeRest);
        }
        if (insertGeoserverStatus && this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkPutMethods().insertMetadataByFeatureType(featureTypeRest, category, this.getCurrentWmsGeoserver(), description, abstr) != null;
        }
        return insertGeoserverStatus;
    }

    public boolean addFeatureType(FeatureTypeRest featureTypeRest, GeonetworkCommonResourceInterface.GeonetworkCategory category) throws Exception {
        boolean insertGeoserverStatus = true;
        if (!this.layerExists(featureTypeRest.getName())) {
            insertGeoserverStatus = this.geoserverCaller.getGeoserverPutMethods().addFeatureType(featureTypeRest);
        }
        if (insertGeoserverStatus && this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkPutMethods().insertMetadataByFeatureType(featureTypeRest, category, this.getCurrentWmsGeoserver(), null, null) != null;
        }
        return insertGeoserverStatus;
    }

    public boolean layerExists(String layerName) throws Exception {
        return this.layerExists(layerName, 1);
    }

    public boolean groupExists(String groupName) throws Exception {
        return this.groupExists(groupName, 1);
    }

    public boolean layerExists(String layerName, int maxtries) throws Exception {
        String geoserverUrl = this.getGeoServerForLayer(layerName);
        String urlToCheck = geoserverUrl + "/rest/layers/" + layerName + ".json";
        boolean found = false;
        for (int i = 0; i < maxtries && !found; ++i) {
            logger.debug("layerExists->Checking Layer on geoserver " + geoserverUrl);
            int result = this.checkUrl(urlToCheck, this.geoserverUser, this.geoserverPwd);
            logger.debug("layerExists->Cached Layer Checking " + result);
            if (result != 200) continue;
            found = true;
        }
        logger.debug("layerExists->Layer " + layerName + (found ? "" : " not") + " present in " + geoserverUrl);
        return found;
    }

    public boolean groupExists(String groupName, int maxtries) throws Exception {
        String geoserverUrl = this.getGeoServerForGroup(groupName);
        String urlToCheck = geoserverUrl + "/rest/layergroups/" + groupName + ".json";
        boolean found = false;
        for (int i = 0; i < maxtries && !found; ++i) {
            logger.debug("groupExists->Checking Group on geoserver " + geoserverUrl);
            int result = this.checkUrl(urlToCheck, this.geoserverUser, this.geoserverPwd);
            logger.debug("groupExists->Cached Group Checking " + result);
            if (result != 200) continue;
            found = true;
        }
        logger.debug("layerExists->Group " + groupName + (found ? "" : " not") + " present in " + geoserverUrl);
        return found;
    }

    public int checkUrl(String url, final String username, final String password) {
        int checkConn = -1;
        try {
            if (username != null && password != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(username, password.toCharArray());
                    }
                });
            }
            URL checkurl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)checkurl.openConnection();
            checkConn = conn.getResponseCode();
            conn.disconnect();
        }
        catch (Exception e) {
            logger.error("ERROR in URL " + e.getMessage());
        }
        return checkConn;
    }

    public boolean addLayer(LayerRest layerRest) throws Exception {
        return this.geoserverCaller.getGeoserverPutMethods().addLayer(layerRest);
    }

    public boolean setLayer(FeatureTypeRest featureTypeRest, String defaultStyle, ArrayList<String> styles) throws Exception {
        return this.geoserverCaller.getGeoserverPutMethods().setLayer(featureTypeRest, defaultStyle, styles);
    }

    public boolean addStyleToLayer(String layer, String style) throws Exception {
        return this.geoserverCaller.getGeoserverPutMethods().addStyleToLayer(layer, style);
    }

    public boolean sendStyleSDL(String xmlSdl) throws Exception {
        return this.geoserverCaller.getGeoserverPutMethods().sendStyleSDL(xmlSdl);
    }

    public boolean modifyLayersGroup(GroupRest group) throws Exception {
        return this.geoserverCaller.getGeoserverModifyMethods().modifyLayersGroup(group);
    }

    public boolean modifyStyleSDL(String schemaName, String xmlSdl) throws Exception {
        return this.geoserverCaller.getGeoserverModifyMethods().modifyStyleSDL(schemaName, xmlSdl);
    }

    public boolean deleteLayersGroup(String name) throws Exception {
        return this.geoserverCaller.getGeoserverDeleteMethods().deleteLayersGroup(name);
    }

    public boolean deleteStyleSDL(String schemaName, boolean purge) throws Exception {
        return this.geoserverCaller.getGeoserverDeleteMethods().deleteStyleSDL(schemaName, purge);
    }

    public boolean deleteLayer(String LayerName) throws Exception {
        return this.geoserverCaller.getGeoserverDeleteMethods().deleteLayer(LayerName);
    }

    public boolean deleteFeatureTypes(String wokspaceName, String dataStore, String featureTypes) throws Exception {
        return this.geoserverCaller.getGeoserverDeleteMethods().deleteFeatureTypes(wokspaceName, dataStore, featureTypes);
    }

    public String getGeoServerForName(String name, boolean searchgroup) throws Exception {
        ArrayList<CswRecord> cswarray = null;
        if (this.isAvailableGeonetwork) {
            cswarray = this.getGeonetworkCswRecordsBySearch(name, 0);
        }
        String geourl = "";
        if (cswarray != null && cswarray.size() > 0) {
            int s = cswarray.size();
            for (int i = 0; i < s; ++i) {
                boolean isgroup = cswarray.get(i).getAbstractProperty().startsWith("Layer-Group");
                if ((!searchgroup || !isgroup) && (searchgroup || isgroup)) continue;
                geourl = cswarray.get(i).getURI().get(0);
                break;
            }
        } else {
            geourl = this.wmsGeoserverList.get(0);
        }
        if (geourl.length() > 0) {
            int interr = geourl.indexOf("?");
            if (interr > 0) {
                geourl = geourl.substring(0, interr);
            }
            if (geourl.endsWith("/wms") || geourl.endsWith("/gwc") || geourl.endsWith("/wfs")) {
                geourl = geourl.substring(0, geourl.length() - 4);
            }
        }
        return geourl;
    }

    public String getGeoServerForGroup(String groupName) throws Exception {
        return this.getGeoServerForName(groupName, true);
    }

    public String getGeoServerForLayer(String layerName) throws Exception {
        return this.getGeoServerForName(layerName, false);
    }

    public List<String> getLayerTitlesByWms(List<String> workspaces, List<String> layerNames) throws Exception {
        ArrayList<String> res = new ArrayList<String>();
        int len = layerNames.size();
        try {
            for (int i = 0; i < len; ++i) {
                res.add(this.getLayerTitleByWms(workspaces.get(i), layerNames.get(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getLayerTitleByWms(String workspace, String layerName) {
        String res = null;
        try {
            String geoserverUrl = this.getGeoServerForName(layerName, false);
            GeoserverCaller geoserver = new GeoserverCaller(geoserverUrl, this.geoserverUser, this.geoserverPwd);
            res = geoserver.getLayerTitleByWms(workspace, layerName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public CswLayersResult getLayersFromCsw() throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getLayersFromCsw(null, 1, 0, false, false, FILTER_TYPE.NO_FILTER, null);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public CswLayersResult getLayersFromCsw(String referredWorkspace) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getLayersFromCsw(referredWorkspace, 1, 0, false, false, FILTER_TYPE.NO_FILTER, null);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public CswLayersResult getLayersFromCsw(String referredWorkspace, int startPosition, int maxRecords) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getLayersFromCsw(referredWorkspace, startPosition, maxRecords, false, false, FILTER_TYPE.NO_FILTER, null);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public CswLayersResult getLayersFromCsw(String referredWorkspace, int startPosition, int maxRecords, boolean sortByTiyle, boolean sortAscendent) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getLayersFromCsw(referredWorkspace, startPosition, maxRecords, sortByTiyle, sortAscendent, FILTER_TYPE.NO_FILTER, null);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public CswLayersResult getLayersFromCsw(String referredWorkspace, int startPosition, int maxRecords, boolean sortByTitle, boolean sortAscendent, FILTER_TYPE filter, String textToSearch) throws Exception {
        if (this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getLayersFromCsw(referredWorkspace, startPosition, maxRecords, sortByTitle, sortAscendent, filter, textToSearch);
        }
        throw new Exception("Geonetwork is not instantiated");
    }

    public void close() {
        if (this.isAvailableGeonetwork && this.geonetworkCaller != null) {
            this.geonetworkCaller.logoutGeonetwork();
        }
    }

    public boolean addFeatureType(FeatureTypeRest featureTypeRest, String defaultStyle, GeonetworkCommonResourceInterface.GeonetworkCategory category, Metadata toPublishMeta) throws Exception {
        boolean insertGeoserverStatus = true;
        if (!this.layerExists(featureTypeRest.getName())) {
            insertGeoserverStatus = this.geoserverCaller.getGeoserverPutMethods().addFeatureType(featureTypeRest);
        }
        if (insertGeoserverStatus && this.isAvailableGeonetwork) {
            return this.geonetworkCaller.getGeonetworkPutMethods().insertMetadataByFeatureType(featureTypeRest, defaultStyle, category, this.getCurrentWmsGeoserver(), toPublishMeta) != null;
        }
        return insertGeoserverStatus;
    }

    public boolean addPreExistentGeoTiff(String fileName, String layerName, String layerTitle, String workspace, GeonetworkCommonResourceInterface.GeonetworkCategory category, Metadata toPublishMeta, String defaultStyle) throws Exception {
        File geotiff;
        boolean insertGeoserverStatus = true;
        GeoServerRESTPublisher publisher = new GeoServerRESTPublisher(this.currentWmsGeoserver, this.geoserverUser, this.geoserverPwd);
        String storeName = "store_" + layerName;
        insertGeoserverStatus = publisher.publishExternalGeoTIFF(workspace, storeName, geotiff = new File(Constants.getGeoserverDataAbsolutePath() + workspace + "/" + fileName), layerName, "EPSG:4326", GSResourceEncoder.ProjectionPolicy.REPROJECT_TO_DECLARED, "raster");
        if (insertGeoserverStatus && this.isAvailableGeonetwork) {
            FeatureTypeRest featureTypeRest = new FeatureTypeRest();
            featureTypeRest.setName(layerName);
            featureTypeRest.setTitle(layerTitle);
            featureTypeRest.setWorkspace(workspace);
            featureTypeRest.setLatLonBoundingBox(new BoundsRest(-180.0, 180.0, -85.5, 90.0, "EPSG:4326"));
            featureTypeRest.setNativeBoundingBox(new BoundsRest(-180.0, 180.0, -85.5, 90.0, "EPSG:4326"));
            boolean insertGeonetworkSataus = this.geonetworkCaller.getGeonetworkPutMethods().insertMetadataByFeatureType(featureTypeRest, defaultStyle, category, this.getCurrentWmsGeoserver(), toPublishMeta) != null;
            return insertGeonetworkSataus;
        }
        return insertGeoserverStatus;
    }

    public static enum FILTER_TYPE {
        NO_FILTER,
        TITLE,
        ANY_TEXT;

    }
}

