/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreatorManager;
import org.gcube.common.homelibrary.jcr.workspace.JCRFolderBulkCreator;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRFolderBulkCreatorManager
implements FolderBulkCreatorManager {
    Logger logger;
    final JCRWorkspace workspace;
    protected Map<String, Thread> threads = new LinkedHashMap<String, Thread>();

    public JCRFolderBulkCreatorManager(JCRWorkspace workspace) {
        this.logger = LoggerFactory.getLogger(JCRFolderBulkCreatorManager.class);
        this.workspace = workspace;
    }

    public FolderBulkCreator getFolderBulk(JCRWorkspaceFolder destinationFolder) throws InternalErrorException {
        String name = UUID.randomUUID().toString();
        return new JCRFolderBulkCreator(name, destinationFolder, this);
    }

    public void removeThread(String id) throws InternalErrorException {
        this.threads.remove(id);
    }

    public void addFolderBulkCreator(FolderBulkCreator folderBulk, Thread th) throws InternalErrorException {
        this.threads.put(folderBulk.getId(), th);
    }

    public List<FolderBulkCreator> getActiveFolderBulkCreators() {
        return null;
    }

    public FolderBulkCreator getActiveFolderBulkCreator(String id) throws InternalErrorException {
        return null;
    }

    public void waitFolderBulkCreator(String id) throws InterruptedException {
        Thread th = this.threads.get(id);
        if (th != null) {
            th.join();
        }
    }
}

