/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import com.thoughtworks.xstream.XStream;
import java.util.Calendar;
import java.util.Map;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryDelete;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRAccountingEntryDelete
extends JCRAccountingEntry
implements AccountingEntryDelete {
    protected String itemName;
    protected String from;

    public JCRAccountingEntryDelete(AccountingDelegate node) throws RepositoryException {
        super(node);
        this.itemName = (String)new XStream().fromXML((String)node.getAccountingProperties().get(AccountingProperty.ITEM_NAME));
        this.from = (String)new XStream().fromXML((String)node.getAccountingProperties().get(AccountingProperty.FROM_PATH));
    }

    public JCRAccountingEntryDelete(String id, String user, Calendar date, String nodeName, String from) {
        super(id, user, date);
        this.itemName = nodeName;
        this.from = from;
        Map properties = this.entryDelegate.getAccountingProperties();
        properties.put(AccountingProperty.ITEM_NAME, new XStream().toXML((Object)this.itemName));
        properties.put(AccountingProperty.FROM_PATH, new XStream().toXML((Object)from));
        this.entryDelegate.setEntryType(AccountingEntryType.DELETE);
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.DELETE;
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s, itemName:%s, deletedFrom:%s]]", parentValue, this.getEntryType(), this.getItemName(), this.getDeletedFrom());
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getDeletedFrom() {
        return this.from;
    }
}

