/*
 * Decompiled with CFR 0.152.
 */
package liblinear;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import liblinear.FeatureNode;
import liblinear.Linear;
import liblinear.Model;
import liblinear.Parameter;
import liblinear.Problem;
import liblinear.SolverType;

public class Train {
    private double bias = 1.0;
    private boolean cross_validation = false;
    private String inputFilename;
    private String modelFilename;
    private int nr_fold;
    private Parameter param = null;
    private Problem prob = null;

    public static void main(String[] args) throws IOException {
        new Train().run(args);
    }

    private void do_cross_validation() {
        int[] target = new int[this.prob.l];
        Linear.crossValidation(this.prob, this.param, this.nr_fold, target);
        int total_correct = 0;
        int i = 0;
        while (i < this.prob.l) {
            if (target[i] == this.prob.y[i]) {
                ++total_correct;
            }
            ++i;
        }
    }

    private void exit_with_help() {
        System.out.println("Usage: train [options] training_set_file [model_file]" + Linear.NL + "options:" + Linear.NL + "-s type : set type of solver (default 1)" + Linear.NL + "   0 -- L2-regularized logistic regression" + Linear.NL + "   1 -- L2-loss support vector machines (dual)" + Linear.NL + "   2 -- L2-loss support vector machines (primal)" + Linear.NL + "   3 -- L1-loss support vector machines (dual)" + Linear.NL + "   4 -- multi-class support vector machines by Crammer and Singer" + Linear.NL + "-c cost : set the parameter C (default 1)" + Linear.NL + "-e epsilon : set tolerance of termination criterion" + Linear.NL + "   -s 0 and 2" + Linear.NL + "       |f'(w)|_2 <= eps*min(pos,neg)/l*|f'(w0)|_2," + Linear.NL + "       where f is the primal function, (default 0.01)" + Linear.NL + "   -s 1, 3, and 4" + Linear.NL + "       Dual maximal violation <= eps; similar to libsvm (default 0.1)" + Linear.NL + "-B bias : if bias >= 0, instance x becomes [x; bias]; if < 0, no bias term added (default 1)" + Linear.NL + "-wi weight: weights adjust the parameter C of different classes (see README for details)" + Linear.NL + "-v n: n-fold cross validation mode" + Linear.NL);
        System.exit(1);
    }

    Problem getProblem() {
        return this.prob;
    }

    double getBias() {
        return this.bias;
    }

    Parameter getParameter() {
        return this.param;
    }

    void parse_command_line(String[] argv) {
        this.param = new Parameter(SolverType.L2LOSS_SVM_DUAL, 1.0, Double.POSITIVE_INFINITY);
        this.bias = 1.0;
        this.cross_validation = false;
        int nr_weight = 0;
        int i = 0;
        while (i < argv.length) {
            if (argv[i].charAt(0) != '-') break;
            if (++i >= argv.length) {
                this.exit_with_help();
            }
            switch (argv[i - 1].charAt(1)) {
                case 's': {
                    this.param.solverType = SolverType.values()[Linear.atoi(argv[i])];
                    break;
                }
                case 'c': {
                    this.param.setC(Linear.atof(argv[i]));
                    break;
                }
                case 'e': {
                    this.param.setEps(Linear.atof(argv[i]));
                    break;
                }
                case 'B': {
                    this.bias = Linear.atof(argv[i]);
                    break;
                }
                case 'w': {
                    Object[] old = this.param.weightLabel;
                    this.param.weightLabel = new int[++nr_weight];
                    System.arraycopy(old, 0, this.param.weightLabel, 0, nr_weight - 1);
                    old = this.param.weight;
                    this.param.weight = new double[nr_weight];
                    System.arraycopy(old, 0, this.param.weight, 0, nr_weight - 1);
                    this.param.weightLabel[nr_weight - 1] = Linear.atoi(argv[i - 1].substring(2));
                    this.param.weight[nr_weight - 1] = Linear.atof(argv[i]);
                    break;
                }
                case 'v': {
                    this.cross_validation = true;
                    this.nr_fold = Linear.atoi(argv[i]);
                    if (this.nr_fold >= 2) break;
                    System.err.print("n-fold cross validation: n must >= 2\n");
                    this.exit_with_help();
                    break;
                }
                default: {
                    System.err.println("unknown option");
                    this.exit_with_help();
                }
            }
            ++i;
        }
        if (i >= argv.length) {
            this.exit_with_help();
        }
        this.inputFilename = argv[i];
        if (i < argv.length - 1) {
            this.modelFilename = argv[i + 1];
        } else {
            int p = argv[i].lastIndexOf(47);
            this.modelFilename = String.valueOf(argv[i].substring(++p)) + ".model";
        }
        if (this.param.eps == Double.POSITIVE_INFINITY) {
            if (this.param.solverType == SolverType.L2_LR || this.param.solverType == SolverType.L2LOSS_SVM) {
                this.param.setEps(0.01);
            } else if (this.param.solverType == SolverType.L2LOSS_SVM_DUAL || this.param.solverType == SolverType.L1LOSS_SVM_DUAL || this.param.solverType == SolverType.MCSVM_CS) {
                this.param.setEps(0.1);
            }
        }
    }

    void readProblem(String filename) throws IOException {
        BufferedReader fp = new BufferedReader(new FileReader(filename));
        ArrayList<Integer> vy = new ArrayList<Integer>();
        ArrayList<FeatureNode[]> vx = new ArrayList<FeatureNode[]>();
        int max_index = 0;
        try {
            String line;
            while ((line = fp.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, " \t\n\r\f:");
                String token = st.nextToken();
                vy.add(Linear.atoi(token));
                int m = st.countTokens() / 2;
                FeatureNode[] x = this.bias >= 0.0 ? new FeatureNode[m + 1] : new FeatureNode[m];
                int j = 0;
                while (j < m) {
                    int index = Linear.atoi(st.nextToken());
                    double value = Linear.atof(st.nextToken());
                    x[j] = new FeatureNode(index, value);
                    ++j;
                }
                if (m > 0) {
                    max_index = Math.max(max_index, x[m - 1].index);
                }
                vx.add(x);
            }
            this.prob = new Problem();
            this.prob.bias = this.bias;
            this.prob.l = vy.size();
            this.prob.n = max_index;
            if (this.bias >= 0.0) {
                ++this.prob.n;
            }
            this.prob.x = new FeatureNode[this.prob.l][];
            int i = 0;
            while (i < this.prob.l) {
                this.prob.x[i] = (FeatureNode[])vx.get(i);
                if (this.bias >= 0.0) {
                    assert (this.prob.x[i][this.prob.x[i].length - 1] == null);
                    this.prob.x[i][this.prob.x[i].length - 1] = new FeatureNode(max_index + 1, this.bias);
                } else assert (this.prob.x[i][this.prob.x[i].length - 1] != null);
                ++i;
            }
            this.prob.y = new int[this.prob.l];
            i = 0;
            while (i < this.prob.l) {
                this.prob.y[i] = (Integer)vy.get(i);
                ++i;
            }
        }
        finally {
            fp.close();
        }
    }

    private void run(String[] args) throws IOException {
        this.parse_command_line(args);
        this.readProblem(this.inputFilename);
        if (this.cross_validation) {
            this.do_cross_validation();
        } else {
            Model model = Linear.train(this.prob, this.param);
            Linear.saveModel(new File(this.modelFilename), model);
        }
    }
}

