/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IORetrievalOperator
extends Operator {
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String PARAMETER_REMOVE_FROM_STORE = "remove_from_store";
    private String[] objectArray = null;

    public IORetrievalOperator(OperatorDescription description) {
        super(description);
    }

    private Class<IOObject> getSelectedClass() throws UndefinedParameterError {
        int ioType = this.getParameterAsInt(PARAMETER_IO_OBJECT);
        if (this.objectArray != null) {
            return OperatorService.getIOObjectClass(this.objectArray[ioType]);
        }
        return null;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Class<IOObject> clazz = this.getSelectedClass();
        IOObject object = null;
        if (clazz != null) {
            String name = this.getParameterAsString(PARAMETER_NAME);
            object = this.getProcess().retrieve(name, this.getParameterAsBoolean(PARAMETER_REMOVE_FROM_STORE));
            if (object == null) {
                throw new UserError((Operator)this, 941, name);
            }
            if (!clazz.isInstance(object)) {
                throw new UserError((Operator)this, 940, name, this.objectArray[this.getParameterAsInt(PARAMETER_IO_OBJECT)]);
            }
            if (this.getParameterAsBoolean(PARAMETER_REMOVE_FROM_STORE)) {
                return new IOObject[]{object};
            }
            return new IOObject[]{object.copy()};
        }
        return new IOObject[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        Class<IOObject> clazz = null;
        try {
            clazz = this.getSelectedClass();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (clazz != null) {
            return new Class[]{clazz};
        }
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_NAME, "The name under which the specified object is stored and can later be retrieved.", false));
        Set<String> ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = i.next();
        }
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object which should be stored.", this.objectArray, 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_FROM_STORE, "Indicates if the stored object should be removed from the process store so that following operators can retrieve it again from the store.", true));
        return types;
    }
}

