/*
 * Decompiled with CFR 0.152.
 */
import com.rapidminer.tools.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class StyleCheck {
    private static final String SIZE_CHECK = "size_check";
    private static final String LINES_COUNT = "total_lines";
    private static final String COMMENT_CHECK = "comment_check";
    private static final String AUTHOR_CHECK = "author_check";
    private static final String AUTHOR_LIST = "author_list";
    private static final String AUTHOR_COUNT = "author_count";
    private static final String AUTHOR_REPLACE = "author_replace";
    private static final String ALL_AUTHORS = "all_authors";
    private static final String LICENSE_CHECK = "license_check";

    public static void checkSize(String[] argv) throws Exception {
        if (argv.length != 3) {
            System.err.println("usage: java StyleCheck size_check max_lines path");
            System.exit(1);
        }
        SizeChecker checker = new SizeChecker(Integer.parseInt(argv[1]));
        checker.checkAllFiles(new File(argv[2]));
        checker.printResult();
    }

    public static void countLines(String[] argv) throws Exception {
        if (argv.length != 2) {
            System.err.println("usage: java StyleCheck total_lines path");
            System.exit(1);
        }
        LineCounter checker = new LineCounter();
        checker.checkAllFiles(new File(argv[1]));
        ((JavaFileChecker)checker).printResult();
    }

    public static void checkComment(String[] argv) throws Exception {
        if (argv.length != 2) {
            System.err.println("usage: java StyleCheck comment_check path");
            System.exit(1);
        }
        CommentChecker checker = new CommentChecker();
        checker.checkAllFiles(new File(argv[1]));
        checker.printResult();
    }

    public static void checkAuthor(String[] argv) throws Exception {
        if (argv.length != 2) {
            System.err.println("usage: java StyleCheck author_check path");
            System.exit(1);
        }
        AuthorChecker checker = new AuthorChecker();
        checker.checkAllFiles(new File(argv[1]));
        checker.printResult();
    }

    public static void createAuthorList(String[] argv) throws Exception {
        if (argv.length < 3 || argv.length > 4) {
            System.err.println("usage: java StyleCheck author_list path authorname [exceptauthor]");
            System.exit(1);
        }
        AuthorList checker = null;
        checker = argv.length == 3 ? new AuthorList(argv[2]) : new AuthorList(argv[2], argv[3]);
        checker.checkAllFiles(new File(argv[1]));
        ((JavaFileChecker)checker).printResult();
    }

    public static void createAuthorCount(String[] argv) throws Exception {
        if (argv.length != 3) {
            System.err.println("usage: java StyleCheck author_count authorName path");
            System.exit(1);
        }
        AuthorCounter checker = new AuthorCounter(argv[1]);
        checker.checkAllFiles(new File(argv[2]));
        ((JavaFileChecker)checker).printResult();
    }

    public static void replaceAuthor(String[] argv) throws Exception {
        if (argv.length != 4) {
            System.err.println("usage: java StyleCheck author_replace oldAuthorName newAuthorName path");
            System.exit(1);
        }
        AuthorReplace checker = new AuthorReplace(argv[1], argv[2]);
        checker.checkAllFiles(new File(argv[3]));
        ((JavaFileChecker)checker).printResult();
    }

    public static void listAllAuthors(String[] argv) throws Exception {
        if (argv.length != 2) {
            System.err.println("usage: java StyleCheck all_authors path");
            System.exit(1);
        }
        AllAuthors checker = new AllAuthors();
        checker.checkAllFiles(new File(argv[1]));
        ((JavaFileChecker)checker).printResult();
    }

    public static void checkForLicenseText(String[] argv) throws Exception {
        if (argv.length != 2) {
            System.err.println("usage: java StyleCheck license_check path");
            System.exit(1);
        }
        LicenseChecker checker = new LicenseChecker();
        checker.checkAllFiles(new File(argv[1]));
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length < 2) {
            System.err.println("usage: java StyleCheck command <arguments> path");
            System.exit(1);
        }
        if (argv[0].equals(SIZE_CHECK)) {
            StyleCheck.checkSize(argv);
        } else if (argv[0].equals(LINES_COUNT)) {
            StyleCheck.countLines(argv);
        } else if (argv[0].equals(COMMENT_CHECK)) {
            StyleCheck.checkComment(argv);
        } else if (argv[0].equals(AUTHOR_CHECK)) {
            StyleCheck.checkAuthor(argv);
        } else if (argv[0].equals(AUTHOR_LIST)) {
            StyleCheck.createAuthorList(argv);
        } else if (argv[0].equals(AUTHOR_COUNT)) {
            StyleCheck.createAuthorCount(argv);
        } else if (argv[0].equals(AUTHOR_REPLACE)) {
            StyleCheck.replaceAuthor(argv);
        } else if (argv[0].equals(ALL_AUTHORS)) {
            StyleCheck.listAllAuthors(argv);
        } else if (argv[0].equals(LICENSE_CHECK)) {
            StyleCheck.checkForLicenseText(argv);
        } else {
            System.err.println("Unknown command: " + argv[0]);
            System.exit(1);
        }
    }

    private static class AllAuthors
    extends JavaFileChecker {
        private int totalLines = 0;
        private int totalClasses = 0;
        private SortedMap<String, Integer> authorClassNumberMap = new TreeMap<String, Integer>();
        private SortedMap<String, Integer> authorLineNumberMap = new TreeMap<String, Integer>();

        private AllAuthors() {
        }

        public void performCheck(File file) throws Exception {
            ++this.totalClasses;
            String[] authors = null;
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = null;
            int lines = 0;
            while ((line = in.readLine()) != null) {
                ++lines;
                int index = line.indexOf("@author");
                if (index <= 0) continue;
                String authorLine = line.substring(index + "@author".length());
                authors = authorLine.split(",");
            }
            this.totalLines += lines;
            if (authors != null) {
                int i = 0;
                while (i < authors.length) {
                    String currentAuthor = authors[i].trim();
                    Integer classCounter = (Integer)this.authorClassNumberMap.get(currentAuthor);
                    if (classCounter == null) {
                        this.authorClassNumberMap.put(currentAuthor, 1);
                    } else {
                        this.authorClassNumberMap.put(currentAuthor, classCounter + 1);
                    }
                    Integer lineCounter = (Integer)this.authorLineNumberMap.get(currentAuthor);
                    if (lineCounter == null) {
                        this.authorLineNumberMap.put(currentAuthor, lines);
                    } else {
                        this.authorLineNumberMap.put(currentAuthor, lineCounter + lines);
                    }
                    ++i;
                }
            }
            in.close();
        }

        public void printResult() {
            System.out.println("Total number of classes: " + this.totalClasses);
            System.out.println("Total number of lines:   " + this.totalLines);
            System.out.println("----------------------------------------------------------");
            NumberFormat formatter = NumberFormat.getPercentInstance();
            formatter.setMaximumFractionDigits(1);
            formatter.setMinimumFractionDigits(1);
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class AuthorCounts
            implements Comparable<AuthorCounts> {
                private String name;
                private int lines;
                private int classes;
                private NumberFormat formatter;

                public AuthorCounts(String name, int lines, int classes, NumberFormat formatter) {
                    this.name = name;
                    this.lines = lines;
                    this.classes = classes;
                    this.formatter = formatter;
                }

                @Override
                public int compareTo(AuthorCounts a) {
                    return -1 * Double.compare(this.classes, a.classes);
                }

                public boolean equals(Object o) {
                    if (!(o instanceof AuthorCounts)) {
                        return false;
                    }
                    return this.name.equals(((AuthorCounts)o).name);
                }

                public int hashCode() {
                    return this.name.hashCode();
                }

                public int getStringLength() {
                    return (String.valueOf(this.name) + ": " + this.classes + " (" + this.lines + " lines)").length();
                }

                public String toString(int numberOfSpaces) {
                    StringBuffer spaceString = new StringBuffer();
                    int i = 0;
                    while (i < numberOfSpaces) {
                        spaceString.append(" ");
                        ++i;
                    }
                    double classPercent = (double)this.classes / (double)AllAuthors.this.totalClasses;
                    double linesPercent = (double)this.lines / (double)AllAuthors.this.totalLines;
                    return String.valueOf(this.name) + ": " + this.classes + " (" + this.lines + " lines) " + spaceString + " --> " + this.formatter.format(classPercent) + " (" + this.formatter.format(linesPercent) + ")";
                }
            }
            LinkedList<AuthorCounts> authorCounters = new LinkedList<AuthorCounts>();
            Iterator<String> i = this.authorClassNumberMap.keySet().iterator();
            int maxLength = 0;
            while (i.hasNext()) {
                String author = i.next();
                int classNumber = (Integer)this.authorClassNumberMap.get(author);
                int lineNumber = (Integer)this.authorLineNumberMap.get(author);
                AuthorCounts newCounter = new AuthorCounts(author, lineNumber, classNumber, formatter);
                authorCounters.add(newCounter);
                maxLength = Math.max(maxLength, newCounter.getStringLength());
            }
            Collections.sort(authorCounters);
            for (AuthorCounts current : authorCounters) {
                System.out.println(current.toString(maxLength - current.getStringLength()));
            }
            System.out.println("----------------------------------------------------------");
        }
    }

    private static class AuthorChecker
    extends JavaFileChecker {
        private AuthorChecker() {
        }

        public void performCheck(File file) throws Exception {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = null;
            boolean authorFound = false;
            while ((line = in.readLine()) != null) {
                if (line.indexOf("@author") <= 0) continue;
                authorFound = true;
                break;
            }
            in.close();
            if (!authorFound) {
                System.out.println(String.valueOf(file.getPath()) + ": missing @author tag!");
            }
        }
    }

    private static class AuthorCounter
    extends JavaFileChecker {
        private String author;
        private int counter = 0;
        private int total = 0;

        public AuthorCounter(String author) {
            this.author = author;
        }

        public void performCheck(File file) throws Exception {
            ++this.total;
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.indexOf("@author") <= 0 || line.toLowerCase().indexOf(this.author.toLowerCase()) <= 0) continue;
                ++this.counter;
                break;
            }
            in.close();
        }

        public void printResult() {
            System.out.println("Number of classes written by " + this.author + ": " + this.counter + " / " + this.total);
        }
    }

    private static class AuthorList
    extends JavaFileChecker {
        private String author;
        private String exceptAuthor;
        private List<String> result = new LinkedList<String>();

        public AuthorList(String author) {
            this(author, null);
        }

        public AuthorList(String author, String exceptAuthor) {
            this.author = author;
            this.exceptAuthor = exceptAuthor;
        }

        public void performCheck(File file) throws Exception {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = in.readLine()) != null) {
                int index = line.indexOf("@author");
                if (index < 0) continue;
                String authorLine = line.substring(index + "@author".length());
                String[] authors = authorLine.split(",");
                boolean authorFound = false;
                boolean exceptAuthorFound = false;
                String[] stringArray = authors;
                int n = authors.length;
                int n2 = 0;
                while (n2 < n) {
                    String a = stringArray[n2];
                    if (a.trim().toLowerCase().indexOf(this.author.toLowerCase()) >= 0) {
                        authorFound = true;
                    }
                    if (this.exceptAuthor != null && a.trim().toLowerCase().indexOf(this.exceptAuthor.trim().toLowerCase()) >= 0) {
                        exceptAuthorFound = true;
                    }
                    ++n2;
                }
                if (!authorFound || exceptAuthorFound) break;
                this.result.add(file.getPath());
                break;
            }
            in.close();
        }

        public void printResult() {
            System.out.println(String.valueOf(this.result.size()) + " classes written by " + this.author + (this.exceptAuthor != null ? " and not by " + this.exceptAuthor + ":" : ":"));
            Iterator<String> i = this.result.iterator();
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        }
    }

    private static class AuthorReplace
    extends JavaFileChecker {
        private String oldName;
        private String newName;
        private int counter = 0;

        public AuthorReplace(String oldName, String newName) {
            this.oldName = oldName;
            this.newName = newName;
        }

        public void performCheck(File file) throws Exception {
            boolean replace = false;
            StringBuffer result = new StringBuffer();
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.indexOf("@author") > 0) {
                    int start;
                    String newAuthorLine = line;
                    if (line.toLowerCase().indexOf(this.newName.toLowerCase()) < 0 && (start = line.toLowerCase().indexOf(this.oldName.toLowerCase())) > 0) {
                        newAuthorLine = String.valueOf(line.substring(0, start)) + this.newName;
                        newAuthorLine = String.valueOf(newAuthorLine) + line.substring(start + this.oldName.length());
                        replace = true;
                    }
                    result.append(String.valueOf(newAuthorLine) + Tools.getLineSeparator());
                    continue;
                }
                result.append(String.valueOf(line) + Tools.getLineSeparator());
            }
            in.close();
            if (replace) {
                ++this.counter;
                FileWriter out = new FileWriter(file);
                out.write(result.toString().toCharArray());
                ((Writer)out).close();
            }
        }

        public void printResult() {
            System.out.println("Number of classes where " + this.oldName + " was replaced by " + this.newName + ": " + this.counter);
        }
    }

    private static class CommentChecker
    extends JavaFileChecker {
        private CommentChecker() {
        }

        public void performCheck(File file) throws Exception {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = null;
            boolean commentFound = false;
            boolean inComment = false;
            boolean packageFound = false;
            while ((line = in.readLine()) != null) {
                if (line.trim().startsWith("package")) {
                    packageFound = true;
                }
                if (!packageFound) continue;
                if (line.trim().startsWith("/**")) {
                    commentFound = true;
                    inComment = true;
                }
                if (inComment && line.indexOf("*/") > 0) {
                    inComment = false;
                }
                if (!inComment && (line.indexOf(" class ") > 0 || line.indexOf(" interface ") > 0)) break;
            }
            in.close();
            if (!commentFound) {
                System.out.println(String.valueOf(file.getPath()) + ": it seems that there is no class comment (or no package...)!");
            }
        }
    }

    private static abstract class JavaFileChecker {
        private JavaFileChecker() {
        }

        public void printResult() {
        }

        public void checkAllFiles(File current) throws Exception {
            if (!current.isDirectory()) {
                if (current.getName().endsWith("java")) {
                    this.performCheck(current);
                }
            } else {
                File[] children = current.listFiles();
                int i = 0;
                while (i < children.length) {
                    this.checkAllFiles(children[i]);
                    ++i;
                }
            }
        }

        public abstract void performCheck(File var1) throws Exception;
    }

    private static class LicenseChecker
    extends JavaFileChecker {
        private static String LICENSE_LINE = "Copyright (C) 2001-2009";

        private LicenseChecker() {
        }

        public void performCheck(File file) throws Exception {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = null;
            boolean licenseFound = false;
            while ((line = in.readLine()) != null) {
                if (line.indexOf(LICENSE_LINE) <= 0) continue;
                licenseFound = true;
                break;
            }
            in.close();
            if (!licenseFound) {
                System.out.println(String.valueOf(file.getPath()) + ": missing or non-conform license");
            }
        }
    }

    private static class LineCounter
    extends JavaFileChecker {
        private int total = 0;

        private LineCounter() {
        }

        public void performCheck(File file) throws Exception {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                ++this.total;
            }
            in.close();
        }

        public void printResult() {
            System.out.println("Total number of lines: " + this.total);
        }
    }

    private static class SizeChecker
    extends JavaFileChecker {
        private int maxLines;

        public SizeChecker(int maxLines) {
            this.maxLines = maxLines;
        }

        public void performCheck(File file) throws Exception {
            BufferedReader in = new BufferedReader(new FileReader(file));
            int counter = 0;
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                ++counter;
            }
            in.close();
            if (counter > this.maxLines) {
                System.out.println(String.valueOf(file.getPath()) + ": more than " + this.maxLines + " lines!");
            }
        }
    }
}

