/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.postprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.AbstractExampleSetProcessing;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleUncertainPredictionsTransformation
extends AbstractExampleSetProcessing {
    public static final String PARAMETER_MIN_CONFIDENCE = "min_confidence";

    public SimpleUncertainPredictionsTransformation(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        if (predictedLabel == null) {
            throw new UserError(this, 107);
        }
        if (!predictedLabel.isNominal()) {
            throw new UserError((Operator)this, 119, predictedLabel, this.getName());
        }
        double minConfidence = this.getParameterAsDouble(PARAMETER_MIN_CONFIDENCE);
        for (Example example : exampleSet) {
            double predictionValue = example.getValue(predictedLabel);
            String predictionClass = predictedLabel.getMapping().mapIndex((int)predictionValue);
            double confidence = example.getConfidence(predictionClass);
            if (Double.isNaN(confidence) || !(confidence < minConfidence)) continue;
            example.setValue(predictedLabel, Double.NaN);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_MIN_CONFIDENCE, "The minimal confidence necessary for not setting the prediction to 'unknown'.", 0.0, 1.0, 0.5);
        type.setExpert(false);
        list.add(type);
        return list;
    }
}

