/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.kernels;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.kernels.Kernel;

public class AnovaKernel
extends Kernel {
    private static final long serialVersionUID = -2955083072613762504L;
    private double gamma = -1.0;
    private double degree;

    public int getType() {
        return 4;
    }

    public void setGamma(double gamma) {
        this.gamma = -gamma;
    }

    public void setDegree(double degree) {
        this.degree = degree;
    }

    public double getGamma() {
        return -this.gamma;
    }

    public double calculateDistance(double[] x1, double[] x2) {
        double result = 0.0;
        int zeros = x1.length;
        int i = 0;
        while (i < x1.length) {
            double factor = x1[i] - x2[i];
            result += Math.exp(this.gamma * factor * factor);
            if (Tools.isNotEqual(x1[i], 0.0) || Tools.isNotEqual(x2[i], 0.0)) {
                --zeros;
            }
            ++i;
        }
        return Math.pow(result += (double)zeros, this.degree);
    }

    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer result = new StringBuffer();
        result.append("pow((");
        boolean first = true;
        int i = 0;
        while (i < x.length) {
            double value = x[i];
            String valueString = "(" + value + " - " + attributeConstructions[i] + ")";
            if (first) {
                result.append("exp(-" + Math.abs(this.gamma) + " * " + valueString + " * " + valueString + ")");
            } else {
                result.append(" + exp(-" + Math.abs(this.gamma) + " * " + valueString + " * " + valueString + ")");
            }
            first = false;
            ++i;
        }
        result.append("), " + this.degree + ")");
        return result.toString();
    }

    public String toString() {
        return "Anova Kernel with" + Tools.getLineSeparator() + "  gamma: " + Tools.formatNumber(this.getGamma()) + Tools.getLineSeparator() + "  degree: " + this.degree;
    }
}

