/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.sound.sampled.AudioInputStream;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.NoSuchPropertyException;
import marytts.modules.SynthesisCallerBase;
import marytts.modules.synthesis.MbrolaVoice;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.util.MaryRuntimeUtils;
import marytts.util.data.audio.AudioDestination;
import marytts.util.data.audio.AudioReader;
import marytts.util.io.StreamLogger;

public class MbrolaCaller
extends SynthesisCallerBase {
    private String baseCmd;
    private int timeout;

    protected MbrolaCaller(String name, MaryDataType inputType, MaryDataType outputType) {
        super(name, inputType, outputType);
    }

    public MbrolaCaller() throws NoSuchPropertyException {
        super("MbrolaCaller", MaryDataType.MBROLA, MaryDataType.AUDIO);
        String basePath = System.getProperty("mary.base") + File.separator + "bin" + File.separator;
        String osName = System.getProperty("os.name");
        this.baseCmd = osName.startsWith("Windows") ? basePath + "mbrola_cygwin.exe" : (osName.equals("Linux") ? basePath + "mbrola-linux-i386" : (osName.startsWith("Mac OS") ? basePath + "mbrola-darwin-ppc" : (osName.equals("Solaris") || osName.equals("SunOS") ? basePath + "mbrola-solaris" : this.findMbrolaBinary(basePath))));
        if (this.baseCmd == null) {
            throw new NullPointerException("No mbrola binary found in " + basePath + " that can be run on this machine.");
        }
        this.logger.debug("Found mbrola binary in " + this.baseCmd);
        this.timeout = MaryProperties.needInteger("modules.timeout");
    }

    @Override
    public AudioInputStream synthesiseOneSection(String mbrolaData, Voice voice) throws IOException {
        assert (this.getState() == 1);
        if (mbrolaData == null || voice == null) {
            throw new IllegalArgumentException("Received null argument.");
        }
        assert (voice instanceof MbrolaVoice) : "Not an MBROLA voice: " + voice.getName();
        String[] cmd = new String[]{this.baseCmd, "-e", ((MbrolaVoice)voice).path(), "-", "-.raw"};
        int MAX_NR_ATTEMPTS = 2;
        int nrAttempts = 0;
        do {
            ++nrAttempts;
            AudioDestination audioDestination = MaryRuntimeUtils.createAudioDestination();
            this.logger.debug("Keeping audio data in " + (audioDestination.isInRam() ? "RAM" : " a temp file"));
            StringBuilder cmdString = new StringBuilder();
            for (int i = 0; i < cmd.length; ++i) {
                cmdString.append(cmd[i]);
                cmdString.append(" ");
            }
            this.logger.info("Starting Synthesis with command: " + cmdString.toString().trim());
            Process process = Runtime.getRuntime().exec(cmd);
            if (System.getProperty("java.vendor").startsWith("Sun") && System.getProperty("java.version").startsWith("1.4.1")) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            PrintWriter toWriter = new PrintWriter((Writer)new OutputStreamWriter(process.getOutputStream()), true);
            BufferedInputStream from = new BufferedInputStream(process.getInputStream());
            StreamLogger errorLogger = new StreamLogger(process.getErrorStream(), this.name() + " err", null);
            errorLogger.start();
            AudioReader readingThread = new AudioReader(from, audioDestination);
            readingThread.start();
            this.logger.info("Writing to module.");
            this.logger.debug("Writing MBROLA input:\n" + mbrolaData + "\n");
            toWriter.print(mbrolaData);
            toWriter.flush();
            toWriter.close();
            boolean timeoutOccurred = false;
            do {
                try {
                    readingThread.join(this.timeout);
                }
                catch (InterruptedException e) {
                    this.logger.warn("Unexpected interruption while waiting for reader thread.");
                }
                boolean bl = timeoutOccurred = System.currentTimeMillis() - readingThread.latestSeenTime() >= (long)this.timeout;
            } while (readingThread.isAlive() && !timeoutOccurred);
            if (process != null) {
                process.destroy();
            }
            if (!timeoutOccurred) {
                return audioDestination.convertToAudioInputStream(voice.dbAudioFormat());
            }
            this.logger.warn("Timeout occurred in attempt " + nrAttempts + " out of " + MAX_NR_ATTEMPTS);
        } while (nrAttempts < MAX_NR_ATTEMPTS);
        throw new IOException("Repeated timeouts -- cannot synthesise.");
    }

    private String findMbrolaBinary(String binPath) {
        String fileSeparator = System.getProperty("file.separator");
        if (!binPath.endsWith(fileSeparator)) {
            binPath = binPath + fileSeparator;
        }
        String[] mbrolas = new File(binPath).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().contains("mbrola");
            }
        });
        String mbrola = null;
        for (String exe : mbrolas) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{binPath + exe, "-h"});
                p.waitFor();
                if (p.exitValue() != 0 && !System.getProperty("os.name").toLowerCase().startsWith("windows")) continue;
                mbrola = exe;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (mbrola != null) {
            return binPath + mbrola;
        }
        return null;
    }
}

