/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateAdjust
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_KEEP_OLD_ATTRIBUTE = "keep_old_attribute";
    public static final String PARAMETER_ADJUSTMENTS = "adjustments";
    public static final String PARAMETER_DATE_UNIT = "date_unit";
    public static final String[] CALENDAR_FIELDS = new String[]{"Year", "Month", "Day", "Hour", "Minute", "Second", "Millisecond"};
    public static final int CALENDAR_FIELD_YEAR = 0;
    public static final int CALENDAR_FIELD_MONTH = 1;
    public static final int CALENDAR_FIELD_DAY = 2;
    public static final int CALENDAR_FIELD_HOUR = 3;
    public static final int CALENDAR_FIELD_MINUTE = 4;
    public static final int CALENDAR_FIELD_SECOND = 5;
    public static final int CALENDAR_FIELD_MILLISECOND = 6;

    public DateAdjust(OperatorDescription description) {
        super(description);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        attributeName = this.getParameterAsString("attribute_name");
        dateAttribute = exampleSet.getAttributes().get(attributeName);
        if (dateAttribute == null) {
            throw new UserError((Operator)this, 111, new Object[]{attributeName});
        }
        if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(dateAttribute.getValueType(), 9)) {
            throw new UserError((Operator)this, 120, new Object[]{attributeName, new Object[]{Ontology.VALUE_TYPE_NAMES[dateAttribute.getValueType()], Ontology.VALUE_TYPE_NAMES[9]}});
        }
        newAttribute = AttributeFactory.createAttribute(dateAttribute.getValueType());
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        adjustments = new LinkedList<Adjustment>();
        adjustmentList = this.getParameterList("adjustments");
        for (String[] keyValuePair : adjustmentList) {
            block15: {
                amount = 0;
                try {
                    amountString = keyValuePair[0].trim();
                    if (amountString.startsWith("+")) {
                        amountString = amountString.substring(1).trim();
                    }
                    amount = Integer.parseInt(amountString);
                }
                catch (NumberFormatException e) {
                    throw new UserError((Operator)this, 116, new Object[]{"adjustments", "please use only integer numbers for the adjustments"});
                }
                field = -1;
                try {
                    field = Integer.parseInt(keyValuePair[1]);
                    break block15;
                }
                catch (NumberFormatException e) {
                    index = 0;
                    found = false;
                    var17_24 = DateAdjust.CALENDAR_FIELDS;
                    var16_23 = DateAdjust.CALENDAR_FIELDS.length;
                    var15_22 = 0;
                    ** while (var15_22 < var16_23)
                }
lbl-1000:
                // 1 sources

                {
                    fieldName = var17_24[var15_22];
                    if (fieldName.equals(keyValuePair[1])) {
                        found = true;
                        break;
                    }
                    ++index;
                    ++var15_22;
                    continue;
                }
lbl41:
                // 2 sources

                if (!found) {
                    throw new UserError((Operator)this, 116, new Object[]{"adjustments", "please use only known calendar units like Year or Hour for the adjustments"});
                }
                field = index;
            }
            adjustments.add(new Adjustment(field, amount));
        }
        this.log("Adjustments: " + adjustments);
        calendar = Tools.getPreferredCalendar();
        for (Example example : exampleSet) {
            date = example.getDateValue(dateAttribute);
            calendar.setTime(date);
            for (Adjustment adjustment : adjustments) {
                calendar.add(adjustment.getField(), adjustment.getAmount());
            }
            example.setValue(newAttribute, calendar.getTime().getTime());
        }
        if (!this.getParameterAsBoolean("keep_old_attribute")) {
            exampleSet.getAttributes().remove(dateAttribute);
            newAttribute.setName(attributeName);
        } else {
            newAttribute.setName(String.valueOf(attributeName) + "_adjusted");
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The attribute which should be parsed.", false));
        types.add(new ParameterTypeList(PARAMETER_ADJUSTMENTS, "This list defines all date adjustments.", new ParameterTypeCategory(PARAMETER_DATE_UNIT, "The unit which should be adjusted.", CALENDAR_FIELDS, 3)));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE, "Indicates if the original date attribute should be kept.", false));
        return types;
    }

    private static class Adjustment {
        private int originalField;
        private int calendarField;
        private int amount;

        public Adjustment(int field, int amount) {
            this.originalField = field;
            switch (field) {
                case 0: {
                    this.calendarField = 1;
                    break;
                }
                case 1: {
                    this.calendarField = 2;
                    break;
                }
                case 2: {
                    this.calendarField = 6;
                    break;
                }
                case 3: {
                    this.calendarField = 11;
                    break;
                }
                case 4: {
                    this.calendarField = 12;
                    break;
                }
                case 5: {
                    this.calendarField = 13;
                    break;
                }
                case 6: {
                    this.calendarField = 14;
                }
            }
            this.amount = amount;
        }

        public int getField() {
            return this.calendarField;
        }

        public int getAmount() {
            return this.amount;
        }

        public String toString() {
            return "Adjust " + CALENDAR_FIELDS[this.originalField] + " (calendar: " + this.calendarField + ") by " + this.amount;
        }
    }
}

