/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.att;

import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.RapidMinerLineReader;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.att.AttributeDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeDataSourceCreator {
    private ArrayList<AttributeDataSource> sources = new ArrayList();

    public List<AttributeDataSource> getAttributeDataSources() {
        return this.sources;
    }

    public void loadData(File file, char[] commentChars, String columnSeparators, char decimalPointCharacter, boolean useQuotes, char quoteChar, char escapeChar, boolean trimLines, boolean firstLineAsNames, int maxCounter, boolean skipErrorLines, Charset encoding, LoggingHandler logging) throws IOException {
        int i;
        this.sources.clear();
        String[] columnNames = null;
        int maxColumns = -1;
        int[] valueTypes = null;
        boolean[] onlyMissing = null;
        RapidMinerLineReader lineReader = new RapidMinerLineReader(columnSeparators, commentChars, useQuotes, quoteChar, escapeChar, trimLines, skipErrorLines);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        int counter = 0;
        boolean first = true;
        while (maxCounter < 0 || counter <= maxCounter) {
            String[] columns = lineReader.readLine(in, -1);
            if (columns == null) break;
            boolean lineOk = true;
            if (maxColumns != -1 && maxColumns != columns.length) {
                lineOk = false;
                if (skipErrorLines) {
                    logging.logWarning("Number of columns in line " + counter + " was unexpected, was: " + columns.length + ", expected: " + maxColumns + ". Skipping line...");
                } else {
                    throw new IOException("Number of columns in line " + counter + " was unexpected, was: " + columns.length + ", expected: " + maxColumns);
                }
            }
            if (lineOk) {
                if (first) {
                    maxColumns = columns.length;
                    valueTypes = new int[maxColumns];
                    onlyMissing = new boolean[maxColumns];
                    i = 0;
                    while (i < valueTypes.length) {
                        valueTypes[i] = 3;
                        onlyMissing[i] = true;
                        ++i;
                    }
                    if (firstLineAsNames) {
                        columnNames = columns;
                    } else {
                        AttributeDataSourceCreator.guessValueTypes(columns, valueTypes, onlyMissing, decimalPointCharacter);
                    }
                    first = false;
                } else {
                    AttributeDataSourceCreator.guessValueTypes(columns, valueTypes, onlyMissing, decimalPointCharacter);
                }
            }
            ++counter;
        }
        in.close();
        int i2 = 0;
        while (i2 < valueTypes.length) {
            if (onlyMissing[i2]) {
                valueTypes[i2] = 1;
            }
            ++i2;
        }
        if (columnNames == null) {
            String defaultName = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
            columnNames = new String[maxColumns];
            int i3 = 0;
            while (i3 < columnNames.length) {
                columnNames[i3] = String.valueOf(defaultName) + " (" + (i3 + 1) + ")";
                ++i3;
            }
        } else if (columnNames.length < maxColumns) {
            String defaultName = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
            String[] newColumnNames = new String[maxColumns];
            System.arraycopy(columnNames, 0, newColumnNames, 0, columnNames.length);
            i = columnNames.length;
            while (i < newColumnNames.length) {
                newColumnNames[i] = String.valueOf(defaultName) + " (" + (i + 1) + ")";
                ++i;
            }
        }
        i = 0;
        while (i < maxColumns) {
            this.sources.add(new AttributeDataSource(AttributeFactory.createAttribute(columnNames[i], valueTypes[i]), file, i, "attribute"));
            ++i;
        }
    }

    public static void guessValueTypes(String[] data, int[] valueTypes, boolean[] onlyMissing, char decimalPointCharacter) {
        int c = 0;
        while (c < valueTypes.length) {
            String value = data[c];
            if (value != null && !value.equals("?") && value.length() > 0) {
                onlyMissing[c] = false;
                try {
                    String valueString = value.replace(decimalPointCharacter, '.');
                    double d = Double.parseDouble(valueString);
                    if (valueTypes[c] == 3 && (double)((int)d) != d) {
                        valueTypes[c] = 4;
                    }
                }
                catch (NumberFormatException e) {
                    valueTypes[c] = 1;
                }
            }
            ++c;
        }
    }
}

