/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;

public class ReflectionCoefficients {
    public static double[] lpc2lprefc(double[] oneMinusA) {
        int i;
        int p = oneMinusA.length - 1;
        double[][] A = new double[p][];
        A[p - 1] = new double[p];
        for (i = 0; i < p; ++i) {
            A[p - 1][i] = oneMinusA[i + 1];
        }
        double[] k = new double[p];
        for (i = p; i >= 1; --i) {
            k[i - 1] = A[i - 1][i - 1];
            if (i < 2) continue;
            A[i - 2] = new double[i];
            for (int j = 1; j < i; ++j) {
                A[i - 2][j - 1] = (A[i - 1][j - 1] + A[i - 1][i - 1] * A[i - 1][i - j - 1]) / (1.0 - k[i - 1] * k[i - 1]);
            }
        }
        double[] oneMinusAHat = ReflectionCoefficients.lprefc2lpc(k);
        return k;
    }

    public static double[] lprefc2lpc(double[] k) {
        int p = k.length;
        double[][] A = new double[p][];
        for (int i = 1; i <= p; ++i) {
            A[i - 1] = new double[i];
            A[i - 1][i - 1] = k[i - 1];
            for (int j = 1; j < i; ++j) {
                A[i - 1][j - 1] = A[i - 2][j - 1] - k[i - 1] * A[i - 2][i - j - 1];
            }
        }
        double[] oneMinusA = new double[p + 1];
        oneMinusA[0] = 1.0;
        System.arraycopy(A[p - 1], 0, oneMinusA, 1, p);
        return oneMinusA;
    }

    public static double[] latticeSynthesisFilter(double[] k, double[] x) {
        int Nx = x.length - 1;
        int M = k.length;
        double[][] fg = new double[x.length][Nx + 1];
        System.arraycopy(x, 0, fg[0], 0, x.length);
        fg[1][0] = 0.0;
        System.arraycopy(x, 0, fg[1], 1, Nx);
        double[][] KMatrix = new double[2][2];
        KMatrix[0][0] = 1.0;
        KMatrix[1][1] = 1.0;
        double[] fg2 = new double[x.length];
        for (int m = 1; m <= M; ++m) {
            KMatrix[0][1] = k[m - 1];
            KMatrix[1][0] = k[m - 1];
            fg = MathUtils.matrixProduct(KMatrix, fg);
            fg2[0] = 0.0;
            System.arraycopy(fg[1], 0, fg2, 1, Nx);
            fg[1] = ArrayUtils.copy(fg2);
        }
        return fg[0];
    }
}

