/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeTypeException;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.tools.Ontology;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Example
implements Serializable,
Map<String, Object> {
    private static final long serialVersionUID = 7761687908683290928L;
    public static final String SEPARATOR = " ";
    public static final String SPARSE_SEPARATOR = ":";
    private DataRow data;
    private ExampleSet parentExampleSet;

    public Example(DataRow data, ExampleSet parentExampleSet) {
        this.data = data;
        this.parentExampleSet = parentExampleSet;
    }

    public DataRow getDataRow() {
        return this.data;
    }

    public Attributes getAttributes() {
        return this.parentExampleSet.getAttributes();
    }

    public double getValue(Attribute a) {
        return this.data.get(a);
    }

    public String getNominalValue(Attribute a) {
        if (!a.isNominal()) {
            throw new AttributeTypeException("Extraction of nominal example value for non-nominal attribute '" + a.getName() + "' is not possible.");
        }
        double value = this.getValue(a);
        if (Double.isNaN(value)) {
            return "?";
        }
        return a.getMapping().mapIndex((int)value);
    }

    public double getNumericalValue(Attribute a) {
        if (!a.isNumerical()) {
            throw new AttributeTypeException("Extraction of numerical example value for non-numerical attribute '" + a.getName() + "' is not possible.");
        }
        return this.getValue(a);
    }

    public Date getDateValue(Attribute a) {
        if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(a.getValueType(), 9)) {
            throw new AttributeTypeException("Extraction of date example value for non-date attribute '" + a.getName() + "' is not possible.");
        }
        return new Date((long)this.getValue(a));
    }

    public void setValue(Attribute a, double value) {
        this.data.set(a, value);
    }

    public void setValue(Attribute a, String str) {
        if (!a.isNominal()) {
            throw new AttributeTypeException("setValue(Attribute, String) only supported for nominal values!");
        }
        if (str != null) {
            this.setValue(a, a.getMapping().mapString(str));
        } else {
            this.setValue(a, Double.NaN);
        }
    }

    public boolean equalValue(Attribute first, Attribute second) {
        if (first.isNominal() && second.isNominal()) {
            return this.getValueAsString(first).equals(this.getValueAsString(second));
        }
        if (!first.isNominal() && !second.isNominal()) {
            return com.rapidminer.tools.Tools.isEqual(this.getValue(first), this.getValue(second));
        }
        return false;
    }

    public double getLabel() {
        return this.getValue(this.getAttributes().getLabel());
    }

    public void setLabel(double value) {
        this.setValue(this.getAttributes().getLabel(), value);
    }

    public double getPredictedLabel() {
        return this.getValue(this.getAttributes().getPredictedLabel());
    }

    public void setPredictedLabel(double value) {
        this.setValue(this.getAttributes().getPredictedLabel(), value);
    }

    public double getId() {
        return this.getValue(this.getAttributes().getId());
    }

    public void setId(double value) {
        this.setValue(this.getAttributes().getId(), value);
    }

    public double getWeight() {
        return this.getValue(this.getAttributes().getWeight());
    }

    public void setWeight(double value) {
        this.setValue(this.getAttributes().getWeight(), value);
    }

    public double getConfidence(String classValue) {
        return this.getValue(this.getAttributes().getSpecial("confidence_" + classValue));
    }

    public void setConfidence(String classValue, double confidence) {
        this.setValue(this.getAttributes().getSpecial("confidence_" + classValue), confidence);
    }

    public String getValueAsString(Attribute attribute) {
        return this.getValueAsString(attribute, -2, false);
    }

    public String getValueAsString(Attribute attribute, int fractionDigits, boolean quoteNominal) {
        double value = this.getValue(attribute);
        return attribute.getAsString(value, fractionDigits, quoteNominal);
    }

    public String toString() {
        return this.toDenseString(-2, true);
    }

    public String toDenseString(int fractionDigits, boolean quoteNominal) {
        StringBuffer result = new StringBuffer();
        Iterator<Attribute> a = this.getAttributes().allAttributes();
        boolean first = true;
        while (a.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(SEPARATOR);
            }
            result.append(this.getValueAsString(a.next(), fractionDigits, quoteNominal));
        }
        return result.toString();
    }

    public String toSparseString(int format, int fractionDigits, boolean quoteNominal) {
        Attribute batchAttribute;
        Attribute weightAttribute;
        Attribute idAttribute;
        StringBuffer str = new StringBuffer();
        Attribute labelAttribute = this.getAttributes().getSpecial("label");
        if (format == 1 && labelAttribute != null) {
            str.append(String.valueOf(this.getValueAsString(labelAttribute, fractionDigits, quoteNominal)) + SEPARATOR);
        }
        if ((idAttribute = this.getAttributes().getSpecial("id")) != null) {
            str.append("id:" + this.getValueAsString(idAttribute, fractionDigits, quoteNominal) + SEPARATOR);
        }
        if ((weightAttribute = this.getAttributes().getSpecial("weight")) != null) {
            str.append("w:" + this.getValueAsString(weightAttribute, fractionDigits, quoteNominal) + SEPARATOR);
        }
        if ((batchAttribute = this.getAttributes().getSpecial("batch")) != null) {
            str.append("b:" + this.getValueAsString(batchAttribute, fractionDigits, quoteNominal) + SEPARATOR);
        }
        str.append(String.valueOf(this.getAttributesAsSparseString(SEPARATOR, SPARSE_SEPARATOR, fractionDigits, quoteNominal)) + SEPARATOR);
        if (format == 2 && labelAttribute != null) {
            str.append("l:" + this.getValueAsString(labelAttribute, fractionDigits, quoteNominal));
        }
        if (format == 0 && labelAttribute != null) {
            str.append(this.getValueAsString(labelAttribute, fractionDigits, quoteNominal));
        }
        return str.toString();
    }

    String getAttributesAsSparseString(String separator, String indexValueSeparator, int fractionDigits, boolean quoteNominal) {
        StringBuffer str = new StringBuffer();
        boolean first = true;
        int counter = 1;
        for (Attribute attribute : this.getAttributes()) {
            double value = this.getValue(attribute);
            if (!Tools.isDefault(attribute.getDefault(), value)) {
                if (!first) {
                    str.append(separator);
                }
                first = false;
                str.append(String.valueOf(counter) + indexValueSeparator + this.getValueAsString(attribute, fractionDigits, quoteNominal));
            }
            ++counter;
        }
        return str.toString();
    }

    @Override
    public Object get(Object key) {
        Attribute attribute = null;
        if (key instanceof String) {
            attribute = this.parentExampleSet.getAttributes().get((String)key);
        }
        if (attribute == null) {
            return null;
        }
        if (attribute.isNominal()) {
            return this.getValueAsString(attribute);
        }
        return this.getValue(attribute);
    }

    @Override
    public Object put(String attributeName, Object value) {
        Attribute attribute = this.parentExampleSet.getAttributes().get(attributeName);
        if (attribute == null) {
            throw new IllegalArgumentException("Unknown attribute name: '" + attributeName + "'");
        }
        if (attribute.isNumerical()) {
            if (value == null) {
                this.setValue(attribute, Double.NaN);
            } else {
                try {
                    double doubleValue = Double.parseDouble(value.toString());
                    this.setValue(attribute, doubleValue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Only numerical values are allowed for numerical attribute: '" + attributeName + "', was '" + value + "'");
                }
            }
        } else if (value == null) {
            this.setValue(attribute, Double.NaN);
        } else {
            this.setValue(attribute, attribute.getMapping().mapString(value.toString()));
        }
        return value;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Clear is not supported by Example.");
    }

    @Override
    public boolean containsKey(Object key) {
        Attribute attribute = null;
        if (key instanceof String) {
            attribute = this.parentExampleSet.getAttributes().get((String)key);
        }
        return attribute != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("ContainsValue is not supported by Example.");
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException("EntrySet is not supported by Example.");
    }

    @Override
    public boolean isEmpty() {
        return this.parentExampleSet.getAttributes().allSize() == 0;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> allKeys = new HashSet<String>();
        Iterator<Attribute> a = this.parentExampleSet.getAttributes().allAttributes();
        while (a.hasNext()) {
            allKeys.add(a.next().getName());
        }
        return allKeys;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException("PutAll is not supported by Example.");
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException("Remove is not supported by Example.");
    }

    @Override
    public int size() {
        return this.parentExampleSet.getAttributes().allSize();
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException("Values is not supported by Example.");
    }
}

