/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.AbstractIOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceLoader
extends AbstractReader<PerformanceVector> {
    public static final String PARAMETER_PERFORMANCE_FILE = "performance_file";

    public PerformanceLoader(OperatorDescription description) {
        super(description, PerformanceVector.class);
    }

    @Override
    public PerformanceVector read() throws OperatorException {
        File performanceFile = this.getParameterAsFile(PARAMETER_PERFORMANCE_FILE);
        PerformanceVector performance = null;
        try {
            FileInputStream in = new FileInputStream(performanceFile);
            performance = (PerformanceVector)AbstractIOObject.read(in);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, performanceFile, e.getMessage());
        }
        return performance;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_PERFORMANCE_FILE, "Filename for the performance file.", "per", false));
        return types;
    }
}

