/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.AbstractPerformanceEvaluator;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Tools;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserBasedPerformanceEvaluator
extends AbstractPerformanceEvaluator {
    public static final String PARAMETER_ADDITIONAL_PERFORMANCE_CRITERIA = "additional_performance_criteria";
    public static final String[] USER_CRITERIA_NAMES = new String[]{"user1", "user2", "user3"};
    private List<PerformanceCriterion> userCriteria = new ArrayList<PerformanceCriterion>();

    public UserBasedPerformanceEvaluator(OperatorDescription description) {
        super(description);
        int i = 0;
        while (i < USER_CRITERIA_NAMES.length) {
            this.addUserPerformanceValue(USER_CRITERIA_NAMES[i], "The user defined performance criterion " + i);
            ++i;
        }
    }

    private void addUserPerformanceValue(final String name, String description) {
        this.addValue(new ValueDouble(name, description){

            public double getDoubleValue() {
                int index = Integer.parseInt(name.substring(4)) - 1;
                PerformanceCriterion c = (PerformanceCriterion)UserBasedPerformanceEvaluator.this.userCriteria.get(index);
                return c.getAverage();
            }
        });
    }

    @Override
    protected void checkCompatibility(ExampleSet exampleSet) throws OperatorException {
    }

    @Override
    protected double[] getClassWeights(Attribute label) throws UndefinedParameterError {
        return null;
    }

    @Override
    protected boolean showCriteriaParameter() {
        return false;
    }

    @Override
    public List<PerformanceCriterion> getCriteria() {
        if (this.userCriteria != null) {
            this.userCriteria.clear();
        }
        LinkedList<PerformanceCriterion> performanceCriteria = new LinkedList<PerformanceCriterion>();
        Iterator<String[]> i = null;
        try {
            i = this.getParameterList(PARAMETER_ADDITIONAL_PERFORMANCE_CRITERIA).iterator();
        }
        catch (UndefinedParameterError e1) {
            this.logError("No additional performance criteria defined. No criteria will be calculated...");
        }
        if (i != null) {
            while (i.hasNext()) {
                String[] keyValue = i.next();
                String className = keyValue[0];
                String parameter = keyValue[1];
                Class criterionClass = null;
                try {
                    criterionClass = Tools.classForName(className);
                    if (PerformanceCriterion.class.isAssignableFrom(criterionClass)) {
                        PerformanceCriterion c = null;
                        if (parameter != null && parameter.trim().length() > 0) {
                            Constructor constructor = criterionClass.getConstructor(String.class);
                            c = (PerformanceCriterion)constructor.newInstance(parameter);
                        } else {
                            c = (PerformanceCriterion)criterionClass.newInstance();
                        }
                        if (!(c instanceof MeasuredPerformance)) {
                            this.logError("Only subclasses of MeasuredPerformance are supported as user based criteria. Skipping '" + className + "'...");
                            continue;
                        }
                        performanceCriteria.add(c);
                        if (this.userCriteria == null) continue;
                        this.userCriteria.add(c);
                        continue;
                    }
                    this.logError("Only subclasses of MeasuredPerformance are supported as user based criteria. Skipping '" + className + "'...");
                }
                catch (ClassNotFoundException e) {
                    this.logError("Class not found: skipping '" + className + "'...");
                }
                catch (InstantiationException e) {
                    this.logError("Cannot instantiate: skipping '" + className + "'...");
                }
                catch (IllegalAccessException e) {
                    this.logError("Cannot access: skipping '" + className + "'...");
                }
                catch (NoSuchMethodException e) {
                    this.logError("No appropriate constructor found: skipping '" + className + "'...");
                }
                catch (InvocationTargetException e) {
                    this.logError("Cannot instantiate constructor: skipping '" + className + "'...");
                }
            }
        }
        return performanceCriteria;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeStringCategory type = new ParameterTypeStringCategory("main_criterion", "The criterion used for comparing performance vectors.", USER_CRITERIA_NAMES, USER_CRITERIA_NAMES[0]);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeList(PARAMETER_ADDITIONAL_PERFORMANCE_CRITERIA, "List of classes that implement com.rapidminer..operator.performance.PerformanceCriterion.", new ParameterTypeString("optional_parameters", "The key must be a fully qualified classname and the value may be a string that is passed to the constructor of this class.", "")));
        return types;
    }
}

