/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.performance.AbstractPerformanceEvaluator;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.tools.GenericOperatorFactory;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.WekaOperatorFactory;
import com.rapidminer.tools.XMLSerialization;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorService {
    public static final String MAIN_OPERATORS_NAME = "core";
    private static Map<String, OperatorDescription> names2descriptions = new HashMap<String, OperatorDescription>();
    private static GroupTree groupTree = new GroupTree("");
    private static Map<String, Class<IOObject>> ioObjects = new TreeMap<String, Class<IOObject>>();

    public static URL getMainOperators() {
        Enumeration<URL> allOperatorsXML = null;
        try {
            allOperatorsXML = OperatorService.class.getClassLoader().getResources("com/rapidminer/resources/operators.xml");
        }
        catch (IOException e) {
            LogService.getGlobal().logWarning("Cannot find any operator description files (XML): " + e.getMessage());
        }
        URL resultURL = null;
        if (allOperatorsXML != null) {
            while (allOperatorsXML.hasMoreElements()) {
                String candidateName;
                URL candidateURL = allOperatorsXML.nextElement();
                InputStream candidateIn = null;
                try {
                    candidateIn = candidateURL.openStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (candidateIn == null) continue;
                Document document = null;
                try {
                    document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(candidateIn);
                }
                catch (Exception e) {
                    LogService.getGlobal().log("Cannot read operator description file '" + candidateURL + "': no valid XML: " + e.getMessage(), 5);
                }
                if (document != null && !document.getDocumentElement().getTagName().toLowerCase().equals("operators")) {
                    LogService.getGlobal().log("Operator description file '" + candidateURL + "': outermost tag must be <operators>!", 5);
                    continue;
                }
                Attr nameAttr = document.getDocumentElement().getAttributeNode("name");
                if (nameAttr != null && (candidateName = nameAttr.getValue()) != null && candidateName.equals(MAIN_OPERATORS_NAME)) {
                    resultURL = candidateURL;
                }
                try {
                    candidateIn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (resultURL != null) break;
            }
        }
        return resultURL;
    }

    public static void registerOperators(String name, InputStream operatorsXML, ClassLoader classLoader, boolean addWekaOperators) {
        Map<String, String> descriptionMap = OperatorService.loadDescriptionMap();
        if (classLoader == null) {
            classLoader = OperatorService.class.getClassLoader();
        }
        LogService.getGlobal().log("Loading operators from '" + name + "'.", 3);
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(operatorsXML);
        }
        catch (Exception e) {
            LogService.getGlobal().log("Cannot read operator description file '" + name + "': no valid XML: " + e.getMessage(), 6);
        }
        if (document != null) {
            if (!document.getDocumentElement().getTagName().toLowerCase().equals("operators")) {
                LogService.getGlobal().log("Operator description file '" + name + "': outermost tag must be <operators>!", 6);
                return;
            }
            NodeList factoryTags = document.getDocumentElement().getElementsByTagName("factory");
            int i = 0;
            while (i < factoryTags.getLength()) {
                Element factoryTag = (Element)factoryTags.item(i);
                Attr classAttr = factoryTag.getAttributeNode("class");
                if (classAttr == null) {
                    LogService.getGlobal().log("Operator description file '" + name + "': factory tag must provide class attribute!", 6);
                } else {
                    Class<?> factoryClass = null;
                    try {
                        factoryClass = classLoader.loadClass(classAttr.getValue());
                    }
                    catch (ClassNotFoundException e) {
                        LogService.getGlobal().log("Operator factory class '" + classAttr.getValue() + "' not found!", 6);
                    }
                    if (factoryClass != null) {
                        if (GenericOperatorFactory.class.isAssignableFrom(factoryClass)) {
                            GenericOperatorFactory factory = null;
                            try {
                                factory = (GenericOperatorFactory)factoryClass.newInstance();
                            }
                            catch (Exception e) {
                                LogService.getGlobal().log("Cannot instantiate operator factory class '" + factoryClass.getName() + "'!", 6);
                            }
                            if (factory != null && (addWekaOperators || !(factory instanceof WekaOperatorFactory))) {
                                factory.registerOperators(classLoader);
                            }
                        } else {
                            LogService.getGlobal().log("Operator description file '" + name + "': only subclasses of GenericOperatorFactory may be defined as class, was '" + classAttr.getValue() + "'!", 6);
                        }
                    }
                }
                ++i;
            }
            NodeList operatorTags = document.getDocumentElement().getElementsByTagName("operator");
            int i2 = 0;
            while (i2 < operatorTags.getLength()) {
                Element currentElement = (Element)operatorTags.item(i2);
                try {
                    OperatorService.registerOperator(currentElement, classLoader, descriptionMap);
                }
                catch (Throwable e) {
                    Attr currentNameAttr = currentElement.getAttributeNode("name");
                    if (currentNameAttr != null) {
                        LogService.getGlobal().log("Cannot register '" + currentNameAttr.getValue() + "': " + e, 6);
                    }
                    LogService.getGlobal().log("Cannot register '" + currentElement + "': " + e, 6);
                }
                ++i2;
            }
        } else {
            LogService.getGlobal().logWarning("Operator description '" + name + "' was empty.");
        }
    }

    private static void registerOperator(Element operatorTag, ClassLoader classLoader, Map<String, String> descriptionMap) throws Exception {
        Attr nameAttr = operatorTag.getAttributeNode("name");
        Attr classAttr = operatorTag.getAttributeNode("class");
        if (nameAttr == null) {
            throw new Exception("Missing name for <operator> tag");
        }
        if (classAttr == null) {
            throw new Exception("Missing class for <operator> tag");
        }
        String name = nameAttr.getValue();
        String shortDescription = operatorTag.getAttribute("description");
        String longDescription = descriptionMap.get(name);
        if (longDescription == null) {
            longDescription = shortDescription;
        }
        OperatorService.registerOperator(classLoader, nameAttr.getValue(), classAttr.getValue(), shortDescription, longDescription, operatorTag.getAttribute("group"), operatorTag.getAttribute("icon"), operatorTag.getAttribute("deprecation"));
    }

    private static void registerOperator(ClassLoader classLoader, String name, String clazz, String shortDescription, String longDescription, String group, String icon, String deprecationInfo) throws Exception {
        OperatorService.registerOperator(new OperatorDescription(classLoader, name, clazz, shortDescription, longDescription, group, icon, deprecationInfo));
    }

    public static void registerOperator(OperatorDescription description) throws Exception {
        OperatorDescription oldDescription = names2descriptions.get(description.getName());
        if (oldDescription != null) {
            LogService.getGlobal().log("An operator '" + description.getName() + "' was already registered. Overwriting...", 5);
        }
        names2descriptions.put(description.getName(), description);
        Operator currentOperator = description.createOperatorInstance();
        OperatorService.checkIOObjects(currentOperator.getInputClasses());
        OperatorService.checkIOObjects(currentOperator.getOutputClasses());
        String groupString = description.getGroup();
        String[] groupNames = groupString.split("\\.");
        GroupTree currentGroup = groupTree;
        int j = 0;
        while (j < groupNames.length) {
            String currentGroupName = groupNames[j].trim();
            if (currentGroupName.length() > 0) {
                GroupTree subGroup = currentGroup.getSubGroup(currentGroupName);
                if (subGroup == null) {
                    subGroup = new GroupTree(currentGroupName);
                    currentGroup.addSubGroup(subGroup);
                }
                currentGroup = subGroup;
            }
            ++j;
        }
        currentGroup.addOperatorDescription(description);
    }

    private static Map<String, String> loadDescriptionMap() {
        HashMap<String, String> descriptionMap;
        block17: {
            URL descriptionUrl = Tools.getResource("long_documentation.txt");
            descriptionMap = new HashMap<String, String>();
            if (descriptionUrl != null) {
                BufferedReader in = null;
                boolean beginNew = true;
                try {
                    try {
                        in = new BufferedReader(new InputStreamReader(descriptionUrl.openStream()));
                        String line = null;
                        String currentName = null;
                        StringBuffer currentDescription = null;
                        while ((line = in.readLine()) != null) {
                            if (line.trim().length() == 0) continue;
                            if (beginNew) {
                                currentName = line;
                                currentDescription = new StringBuffer();
                                beginNew = false;
                                continue;
                            }
                            if (line.startsWith("#####")) {
                                if (currentName != null) {
                                    descriptionMap.put(currentName, currentDescription.toString());
                                    currentName = null;
                                    currentDescription = null;
                                    beginNew = true;
                                    continue;
                                }
                                currentName = null;
                                currentDescription = null;
                                beginNew = true;
                                continue;
                            }
                            String transformed = Tools.removeAllLineSeparators(line);
                            currentDescription.append(transformed);
                        }
                    }
                    catch (IOException e) {
                        LogService.getGlobal().logError("Cannot read long descriptions from resources.");
                        if (in == null) break block17;
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return descriptionMap;
    }

    private static void checkIOObjects(Class[] objects) {
        LinkedList<Class<IOObject>> result = new LinkedList<Class<IOObject>>();
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                result.add(objects[i]);
                ++i;
            }
        }
        OperatorService.checkIOObjects(result);
    }

    private static void checkIOObjects(Collection<Class<IOObject>> objects) {
        for (Class<IOObject> currentClass : objects) {
            String current = currentClass.getName();
            ioObjects.put(current.substring(current.lastIndexOf(".") + 1), currentClass);
        }
    }

    public static Set<String> getIOObjectsNames() {
        return ioObjects.keySet();
    }

    public static void defineXMLAliasPairs() {
        for (Map.Entry<String, Class<IOObject>> entry : ioObjects.entrySet()) {
            String objectName = entry.getKey();
            Class<IOObject> objectClass = entry.getValue();
            XMLSerialization.getXMLSerialization().addAlias(objectName, objectClass);
        }
        for (String name : OperatorService.getOperatorNames()) {
            Operator operator = null;
            try {
                operator = OperatorService.createOperator(name);
            }
            catch (OperatorCreationException operatorCreationException) {
                // empty catch block
            }
            if (operator == null || !(operator instanceof AbstractPerformanceEvaluator)) continue;
            AbstractPerformanceEvaluator evaluator = (AbstractPerformanceEvaluator)operator;
            List<PerformanceCriterion> criteria = evaluator.getCriteria();
            for (PerformanceCriterion criterion : criteria) {
                XMLSerialization.getXMLSerialization().addAlias(criterion.getName(), criterion.getClass());
            }
        }
    }

    public static Set<OperatorDescription> getOperatorsDelivering(Class ioObject) {
        HashSet<OperatorDescription> result = new HashSet<OperatorDescription>();
        for (String name : names2descriptions.keySet()) {
            OperatorDescription description = OperatorService.getOperatorDescription(name);
            try {
                Operator currentOperator = description.createOperatorInstance();
                if (!OperatorService.containsClass(currentOperator.getOutputClasses(), ioObject)) continue;
                result.add(description);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static Set<OperatorDescription> getOperatorsRequiring(Class ioObject) {
        HashSet<OperatorDescription> result = new HashSet<OperatorDescription>();
        for (String name : names2descriptions.keySet()) {
            OperatorDescription description = OperatorService.getOperatorDescription(name);
            try {
                Operator currentOperator = description.createOperatorInstance();
                if (!OperatorService.containsClass(currentOperator.getInputClasses(), ioObject)) continue;
                result.add(description);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean containsClass(Class<?>[] types, Class<?> type) {
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                if (type.isAssignableFrom(types[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static Class<IOObject> getIOObjectClass(String name) {
        return ioObjects.get(name);
    }

    public static Set<String> getOperatorNames() {
        return names2descriptions.keySet();
    }

    public static GroupTree getGroups() {
        return groupTree;
    }

    public static void reloadIcons() {
        for (String name : OperatorService.getOperatorNames()) {
            OperatorDescription description = OperatorService.getOperatorDescription(name);
            description.reloadIcon(null);
        }
    }

    public static OperatorDescription[] getOperatorDescriptions(Class clazz) {
        LinkedList<OperatorDescription> result = new LinkedList<OperatorDescription>();
        Iterator<String> i = names2descriptions.keySet().iterator();
        while (i.hasNext()) {
            OperatorDescription current = OperatorService.getOperatorDescription(i.next());
            if (!current.getOperatorClass().equals(clazz)) continue;
            result.add(current);
        }
        OperatorDescription[] resultArray = new OperatorDescription[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public static OperatorDescription getOperatorDescription(String completeName) {
        return names2descriptions.get(completeName);
    }

    public static Operator createOperator(String typeName) throws OperatorCreationException {
        OperatorDescription description = OperatorService.getOperatorDescription(typeName);
        if (description == null) {
            throw new OperatorCreationException(4, typeName, null);
        }
        return OperatorService.createOperator(description);
    }

    public static Operator createOperator(OperatorDescription description) throws OperatorCreationException {
        return description.createOperatorInstance();
    }

    public static <T extends Operator> T createOperator(Class<T> clazz) throws OperatorCreationException {
        OperatorDescription[] descriptions = OperatorService.getOperatorDescriptions(clazz);
        if (descriptions.length == 0) {
            throw new OperatorCreationException(4, clazz.getName(), null);
        }
        if (descriptions.length > 1) {
            throw new OperatorCreationException(5, clazz.getName(), null);
        }
        return (T)descriptions[0].createOperatorInstance();
    }
}

