/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.templates;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UnknownParameterInformation;
import com.rapidminer.tools.BuildingBlockService;
import com.rapidminer.tools.XMLException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewBuildingBlockMenu
extends JMenu {
    private static final long serialVersionUID = 316102134905132452L;
    private static final String NEW_BUILDING_BLOCK_ICON_NAME = "24/box_new.png";
    private static Icon newBuildingBlockIcon = null;

    static {
        newBuildingBlockIcon = SwingTools.createIcon(NEW_BUILDING_BLOCK_ICON_NAME);
    }

    public NewBuildingBlockMenu() {
        super("New Building Block");
        this.setIcon(newBuildingBlockIcon);
    }

    public void addAllMenuItems() {
        this.setMenuItems(BuildingBlockService.getBuildingBlocks());
    }

    public void setMenuItems(Collection<BuildingBlock> buildingBlocks) {
        this.removeAll();
        for (final BuildingBlock buildingBlock : buildingBlocks) {
            JMenuItem item = null;
            final String name = buildingBlock.getName();
            String iconPath = buildingBlock.getIconPath();
            if (iconPath == null) {
                item = new JMenuItem(name);
            } else {
                ImageIcon icon = SwingTools.createIcon(iconPath);
                item = new JMenuItem(name, icon);
            }
            item.setToolTipText(buildingBlock.getDescription());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String xmlDescription = buildingBlock.getXML();
                    try {
                        InputSource source = new InputSource(new StringReader(xmlDescription));
                        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
                        Element element = document.getDocumentElement();
                        Operator operator = Operator.createFromXML(element, new LinkedList<UnknownParameterInformation>());
                        RapidMinerGUI.getMainFrame().getOperatorTree().insert(operator);
                    }
                    catch (Exception ex) {
                        SwingTools.showSimpleErrorMessage("Cannot instantiate building block '" + name + "'.", ex);
                    }
                }
            });
            item.setEnabled(NewBuildingBlockMenu.checkBuildingBlock(buildingBlock));
            this.add(item);
        }
    }

    public static boolean checkBuildingBlock(BuildingBlock buildingBlock) {
        try {
            String xmlDescription = buildingBlock.getXML();
            InputSource source = new InputSource(new StringReader(xmlDescription));
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
            Element element = document.getDocumentElement();
            Operator operator = Operator.createFromXML(element, new LinkedList<UnknownParameterInformation>());
            operator.remove();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
        catch (SAXException e) {
            return false;
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        catch (XMLException e) {
            return false;
        }
    }
}

