/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.divergences;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.BregmanDivergence;

public class ItakuraSaitoDistance
extends BregmanDivergence {
    private static final long serialVersionUID = -931524423630316788L;

    public double calculateDistance(double[] value1, double[] value2) {
        return value1[0] / value2[0] - Math.log(value1[0] / value2[0]) - 1.0;
    }

    public void init(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNumericalAttributes(exampleSet, "value based similarities");
        Attributes attributes = exampleSet.getAttributes();
        if (attributes.size() != 1) {
            throw new OperatorException("The bregman divergence you've choosen is not applicable for the dataset! Proceeding with the 'Squared Euclidean distance' bregman divergence.");
        }
        for (Example example : exampleSet) {
            for (Attribute attribute : attributes) {
                if (!(example.getValue(attribute) <= 0.0)) continue;
                throw new OperatorException("The bregman divergence you've choosen is not applicable for the dataset! Proceeding with the 'Squared Euclidean distance' bregman divergence.");
            }
        }
    }
}

