/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.util.Iterator;
import java.util.NoSuchElementException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.unitselection.data.FeatureFileReader;
import marytts.unitselection.data.Sentence;

public class SentenceIterator
implements Iterator<Sentence> {
    private final FeatureFileReader features;
    private final int fiSentenceStart;
    private final int fiSentenceEnd;
    private final int fiWordStart;
    private final int fiWordEnd;
    private final boolean isHalfphone;
    private final int fiLR;
    private final int fvLR_L;
    private final int fvLR_R;
    private int i;
    private int len;
    private Sentence nextSentence = null;

    public SentenceIterator(FeatureFileReader features) {
        this.features = features;
        FeatureDefinition featureDefinition = features.getFeatureDefinition();
        this.fiSentenceStart = featureDefinition.getFeatureIndex("words_from_sentence_start");
        this.fiSentenceEnd = featureDefinition.getFeatureIndex("words_from_sentence_end");
        this.fiWordStart = featureDefinition.getFeatureIndex("segs_from_word_start");
        this.fiWordEnd = featureDefinition.getFeatureIndex("segs_from_word_end");
        String halfphoneFeature = "halfphone_lr";
        if (featureDefinition.hasFeature(halfphoneFeature)) {
            this.isHalfphone = true;
            this.fiLR = featureDefinition.getFeatureIndex(halfphoneFeature);
            this.fvLR_L = featureDefinition.getFeatureValueAsByte(this.fiLR, "L");
            this.fvLR_R = featureDefinition.getFeatureValueAsByte(this.fiLR, "R");
        } else {
            this.isHalfphone = false;
            this.fvLR_R = 0;
            this.fvLR_L = 0;
            this.fiLR = 0;
        }
        this.i = 0;
        this.len = features.getNumberOfUnits();
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.nextSentence == null) {
            this.prepareNextSentence();
        }
        return this.nextSentence != null;
    }

    @Override
    public synchronized Sentence next() {
        if (this.nextSentence == null) {
            this.prepareNextSentence();
        }
        if (this.nextSentence == null) {
            throw new NoSuchElementException("no more sentences!");
        }
        Sentence retval = this.nextSentence;
        this.nextSentence = null;
        return retval;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator cannot remove sentences");
    }

    private void prepareNextSentence() {
        if (this.nextSentence != null) {
            return;
        }
        if (this.i >= this.len) {
            return;
        }
        while (this.i < this.len && !this.isSentenceStart(this.i)) {
            ++this.i;
        }
        if (this.i >= this.len) {
            return;
        }
        int iSentenceStart = this.i;
        while (this.i < this.len && !this.isSentenceEnd(this.i)) {
            ++this.i;
        }
        if (this.i >= this.len) {
            return;
        }
        int iSentenceEnd = this.i;
        this.nextSentence = new Sentence(this.features, iSentenceStart, iSentenceEnd);
    }

    private boolean isSentenceStart(int index) {
        FeatureVector fv = this.features.getFeatureVector(index);
        return fv.getByteFeature(this.fiSentenceStart) == 0 && fv.getByteFeature(this.fiWordStart) == 0 && (!this.isHalfphone || fv.getByteFeature(this.fiLR) == this.fvLR_L);
    }

    private boolean isSentenceEnd(int index) {
        FeatureVector fv = this.features.getFeatureVector(index);
        return fv.getByteFeature(this.fiSentenceEnd) == 0 && fv.getByteFeature(this.fiWordEnd) == 0 && (!this.isHalfphone || fv.getByteFeature(this.fiLR) == this.fvLR_R);
    }
}

